/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueTreeCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.CalledMethodStatisticByPackageTreeCreator;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.util.IdentityHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class CallingMethodStatisticByPackageTreeCreator<V extends Value<V>>
extends CalledMethodStatisticByPackageTreeCreator<V> {
    @Override
    protected SelfAndTotalValueTreeCollector<PackageName, V> getChildCollector(ValueIterator<V> it, SelfAndTotalValueTreeNodeImpl<PackageName, V> startNode) throws IOException {
        assert (startNode == null);
        HashMap cache = new HashMap();
        IdentityHashSet seenPackages = new IdentityHashSet();
        MethodFilter methodFilter = it.getMethodFilter();
        MethodFilter inlineFilter = it.getInlineFilter();
        Object empty = it.getEmptyValue();
        SelfAndTotalValueTreeCollector collector = new SelfAndTotalValueTreeCollector(empty);
        while (it.next()) {
            ArrayList nodes;
            StackFrames stack = it.getStack();
            int endSelf = it.getTopSelfRoot();
            int endNonSelf = it.getTopNonSelfRoot();
            int endIndex = Math.max(endSelf, endNonSelf);
            Object value = it.getValue();
            assert (endIndex >= 0);
            if (it.isInlinedAwayCalled(endIndex)) {
                nodes = this.getNodes(it.getInlinedAwayPackage(), collector, empty, cache);
                collector.add(value);
                if (endSelf >= 0) {
                    for (SelfAndTotalValueTreeNodeImpl node : nodes) {
                        node.addSelf(value);
                    }
                }
                for (SelfAndTotalValueTreeNodeImpl node : nodes) {
                    node.addTotal(value);
                }
                continue;
            }
            seenPackages.clear();
            boolean addedAny = false;
            for (int i = 0; i <= endIndex; ++i) {
                MethodObject method = stack.getMethod(i);
                if (inlineFilter != null && inlineFilter.matches(method) || methodFilter != null && !methodFilter.matches(method)) continue;
                if (!addedAny) {
                    collector.add(value);
                    addedAny = true;
                }
                PackageName packageName = method.getMethodClass().getPackage();
                nodes = this.getNodes(packageName, collector, empty, cache);
                boolean isTopOfStack = i <= endSelf;
                for (SelfAndTotalValueTreeNodeImpl node : nodes) {
                    if (!seenPackages.add(node.getKey())) continue;
                    node.addTotal(value);
                    if (!isTopOfStack) continue;
                    node.addSelf(value);
                }
            }
        }
        return collector;
    }
}

