/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalStatisticCreator;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.util.IdentityHashSet;
import java.io.IOException;

public class CallingMethodStatisticCreator<V extends Value<V>>
extends SelfAndTotalStatisticCreator<MethodObject, V> {
    @Override
    protected SelfAndTotalValueStatisticCollector<MethodObject, V> getCollector(ValueIterator<V> it) throws IOException {
        SelfAndTotalValueStatisticCollector collector = new SelfAndTotalValueStatisticCollector(it.getEmptyValue());
        IdentityHashSet seenMethods = new IdentityHashSet();
        MethodFilter methodFilter = it.getMethodFilter();
        MethodFilter inlineFilter = it.getInlineFilter();
        MethodObject inlinedAway = it.getInlinedAwayMethod();
        while (it.next()) {
            int endSelf = it.getTopSelfRoot();
            int endNonSelf = it.getTopNonSelfRoot();
            int endIndex = Math.max(endSelf, endNonSelf);
            Object value = it.getValue();
            assert (endIndex >= 0);
            if (it.isInlinedAwayCalling(endIndex)) {
                collector.addTotal(inlinedAway, value);
                if (endSelf >= 0) {
                    collector.addSelf(inlinedAway, value);
                }
                collector.add(value);
                continue;
            }
            seenMethods.clear();
            boolean addedAny = false;
            StackFrames stack = it.getStack();
            for (int i = 0; i <= endIndex; ++i) {
                MethodObject method = stack.getMethod(i);
                if (inlineFilter != null && inlineFilter.matches(method) || methodFilter != null && !methodFilter.matches(method) || !seenMethods.add((Object)method)) continue;
                addedAny = true;
                if (i <= endSelf) {
                    collector.addSelf(method, value);
                }
                collector.addTotal(method, value);
            }
            if (!addedAny) continue;
            collector.add(value);
        }
        return collector;
    }
}

