/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueTreeCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalTreeCreator;
import com.sap.jvm.profiling.snapshot.util.MethodPath;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;

public class CallingMethodTreeCreator<V extends Value<V>>
extends SelfAndTotalTreeCreator<MethodLocation, V> {
    private static final int MAX_NODES = 50000;
    private static final int MAX_DEPTH = 50;

    @Override
    protected SelfAndTotalValueTreeCollector<MethodLocation, V> getChildCollector(ValueIterator<V> it, SelfAndTotalValueTreeNodeImpl<MethodLocation, V> startNode) throws IOException {
        int currMaxDepth = 50;
        MethodPath path = new MethodPath(startNode);
        int nrOfFramesToMatch = path.length();
        SelfAndTotalValueTreeCollector collector = new SelfAndTotalValueTreeCollector(it.getEmptyValue());
        while (it.next()) {
            StackFrames stack = it.getStack();
            int selfRootOffset = it.getTopSelfRoot();
            int nonSelfRootOffset = it.getTopNonSelfRoot();
            int rootOffset = Math.max(selfRootOffset, nonSelfRootOffset);
            Object value = it.getValue();
            collector.add(value);
            if (!path.matchesReverse(stack, rootOffset)) continue;
            SelfAndTotalValueTreeNodeImpl<MethodLocation, V> parent = startNode;
            int start = rootOffset - nrOfFramesToMatch;
            int end = start - Math.min(currMaxDepth, 1 + rootOffset - nrOfFramesToMatch);
            for (int j = start; j > end; --j) {
                MethodLocation location = stack.getMethodLocation(j);
                SelfAndTotalValueTreeNodeImpl currentNode = new SelfAndTotalValueTreeNodeImpl(parent, location.getMethodLocationWithoutLineNr(), it.getEmptyValue(), it.getEmptyValue(), false);
                currentNode = collector.getOrAdd(currentNode);
                if (j > 0) {
                    currentNode.setHasChildren();
                }
                if (location.getLineNumber() != 0) {
                    currentNode.setHasSubNodes();
                }
                currentNode.addTotal(value);
                if (rootOffset == selfRootOffset) {
                    currentNode.addSelf(value);
                }
                parent = currentNode;
            }
            if (currMaxDepth <= 1 || collector.getNrOfNodes() <= 50000) continue;
            collector.ensureMaxDepth(currMaxDepth + nrOfFramesToMatch);
            --currMaxDepth;
        }
        collector.setMaxDepth(currMaxDepth + nrOfFramesToMatch);
        return collector;
    }

    @Override
    protected SelfAndTotalValueTreeCollector<MethodLocation, V> getSubNodeCollector(ValueIterator<V> it, SelfAndTotalValueTreeNodeImpl<MethodLocation, V> startNode) throws IOException {
        MethodPath path = new MethodPath(startNode);
        int nrOfFramesToMatch = path.length();
        SelfAndTotalValueTreeCollector collector = new SelfAndTotalValueTreeCollector(it.getEmptyValue());
        while (it.next()) {
            StackFrames stack = it.getStack();
            int selfRootOffset = it.getTopSelfRoot();
            int nonSelfRootOffset = it.getTopNonSelfRoot();
            int rootOffset = Math.max(selfRootOffset, nonSelfRootOffset);
            Object value = it.getValue();
            collector.add(value);
            if (!path.matchesReverse(stack, rootOffset)) continue;
            SelfAndTotalValueTreeNodeImpl<MethodLocation, V> parent = startNode;
            int frameIndex = rootOffset - nrOfFramesToMatch + 1;
            MethodLocation location = stack.getMethodLocation(frameIndex);
            if (location.getLineNumber() == 0) continue;
            SelfAndTotalValueTreeNodeImpl currentNode = new SelfAndTotalValueTreeNodeImpl(parent, location, it.getEmptyValue(), it.getEmptyValue(), true);
            currentNode = collector.getOrAdd(currentNode);
            if (frameIndex > 0) {
                currentNode.setHasChildren();
            }
            currentNode.addTotal(value);
            if (rootOffset != selfRootOffset) continue;
            currentNode.addSelf(value);
        }
        collector.setMaxDepth(nrOfFramesToMatch);
        return collector;
    }
}

