/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueTreeCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.ValueTreeCreator;
import com.sap.jvm.profiling.snapshot.util.MethodPath;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;

public class CallingMethodValueTreeCreator<V extends Value<V>>
extends ValueTreeCreator<MethodLocation, V> {
    private static final int MAX_NODES = 50000;
    private static final int MAX_DEPTH = 50;

    @Override
    protected ValueTreeCollector<MethodLocation, V> getChildCollector(ValueIterator<V> it, ValueTreeNodeImpl<MethodLocation, V> startNode) throws IOException {
        int currMaxDepth = 50;
        MethodPath path = new MethodPath(startNode);
        int nrOfFramesToMatch = path.length();
        ValueTreeCollector collector = new ValueTreeCollector(it.getEmptyValue());
        while (it.next()) {
            StackFrames stack = it.getStack();
            int selfRootOffset = it.getTopSelfRoot();
            int nonSelfRootOffset = it.getTopNonSelfRoot();
            int rootOffset = Math.max(selfRootOffset, nonSelfRootOffset);
            Object value = it.getValue();
            collector.add(value);
            if (!path.matchesReverse(stack, rootOffset)) continue;
            ValueTreeNodeImpl<MethodLocation, V> parent = startNode;
            int start = rootOffset - nrOfFramesToMatch;
            int end = start - Math.min(currMaxDepth, 1 + rootOffset - nrOfFramesToMatch);
            for (int j = start; j > end; --j) {
                MethodLocation location = stack.getMethodLocation(j);
                ValueTreeNodeImpl currentNode = new ValueTreeNodeImpl(parent, location.getMethodLocationWithoutLineNr(), it.getEmptyValue(), false);
                currentNode = collector.getOrAdd(currentNode);
                if (j > 0) {
                    currentNode.setHasChildren();
                }
                if (location.getLineNumber() != 0) {
                    currentNode.setHasSubNodes();
                }
                currentNode.addValue(value);
                parent = currentNode;
            }
            if (currMaxDepth <= 1 || collector.getNrOfNodes() <= 50000) continue;
            collector.ensureMaxDepth(currMaxDepth + nrOfFramesToMatch);
            --currMaxDepth;
        }
        collector.setMaxDepth(currMaxDepth + nrOfFramesToMatch);
        return collector;
    }

    @Override
    protected ValueTreeCollector<MethodLocation, V> getSubNodeCollector(ValueIterator<V> it, ValueTreeNodeImpl<MethodLocation, V> startNode) throws IOException {
        MethodPath path = new MethodPath(startNode);
        int nrOfFramesToMatch = path.length();
        ValueTreeCollector collector = new ValueTreeCollector(it.getEmptyValue());
        while (it.next()) {
            StackFrames stack = it.getStack();
            int selfRootOffset = it.getTopSelfRoot();
            int nonSelfRootOffset = it.getTopNonSelfRoot();
            int rootOffset = Math.max(selfRootOffset, nonSelfRootOffset);
            Object value = it.getValue();
            collector.add(value);
            if (!path.matchesReverse(stack, rootOffset)) continue;
            ValueTreeNodeImpl<MethodLocation, V> parent = startNode;
            int frameIndex = rootOffset - nrOfFramesToMatch + 1;
            MethodLocation location = stack.getMethodLocation(frameIndex);
            if (location.getLineNumber() == 0) continue;
            ValueTreeNodeImpl currentNode = new ValueTreeNodeImpl(parent, location, it.getEmptyValue(), true);
            currentNode = collector.getOrAdd(currentNode);
            if (frameIndex > 0) {
                currentNode.setHasChildren();
            }
            currentNode.addValue(value);
        }
        collector.setMaxDepth(nrOfFramesToMatch);
        return collector;
    }
}

