/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.ThreadInfo;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.parameters.MethodParameters;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByMethodParameter;
import com.sap.jvm.profiling.snapshot.elements.FilterByParameterValues;
import com.sap.jvm.profiling.snapshot.impl.resource.MptIteratorAdaptor;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfTotalAndOtherValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfTotalAndOtherStatisticCreator;
import com.sap.jvm.profiling.snapshot.resource.InvocationDist;
import com.sap.jvm.profiling.snapshot.resource.MethodInvocationId;
import com.sap.jvm.profiling.snapshot.resource.SimpleInvocationDist;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;

public class MethodInvocationStatisticCreator<V extends Value<V>>
extends SelfTotalAndOtherStatisticCreator<MethodInvocationId, V, InvocationDist> {
    @Override
    protected SelfTotalAndOtherValueStatisticCollector<MethodInvocationId, V, InvocationDist> getCollector(ValueIterator<V> rawIt) throws IOException {
        ResourceName name = rawIt.getResourceName();
        MptIteratorAdaptor<V> it = new MptIteratorAdaptor<V>(rawIt);
        SelfTotalAndOtherValueStatisticCollector<MethodInvocationId, V, SimpleInvocationDist> collector = new SelfTotalAndOtherValueStatisticCollector<MethodInvocationId, V, SimpleInvocationDist>(it.getEmptyValue(), SimpleInvocationDist.EMPTY);
        String specName = null;
        Parameter[] filterParameters = null;
        ResourceNameElement[] elements = name.getElements();
        for (int i = elements.length - 1; i >= 0; --i) {
            if (elements[i] instanceof FilterByMethodParameter) {
                specName = ((FilterByMethodParameter)elements[i]).getMethodParameterName();
                break;
            }
            if (!(elements[i] instanceof FilterByParameterValues)) continue;
            filterParameters = ((FilterByParameterValues)elements[i]).getValues();
        }
        assert (specName != null);
        while (it.next()) {
            ThreadInfo threadInfo;
            int entryEventTop;
            if (it.isEntry()) {
                MethodParameterEntryEvent entry = it.getEntryEvent();
                MethodParameters params = entry.getParameters();
                for (int i = params.getNrOfParameters() - 1; i >= 0; --i) {
                    MethodParameterSpec spec = params.getSpec(i);
                    if (!MethodInvocationStatisticCreator.checkParameter(spec.getName(), params.getParameter(i), specName, filterParameters)) continue;
                    long entryId = entry.getId();
                    MethodInvocationId id = new MethodInvocationId(entryId);
                    SimpleInvocationDist dist = SimpleInvocationDist.getDist(entry);
                    collector.addOther(id, dist);
                    collector.add(it.getEmptyValue(), dist);
                }
                continue;
            }
            if (it.isExit() || (entryEventTop = (threadInfo = it.getThreadInfo()).getEntryEventTop()) < 0) continue;
            V value = it.getValue();
            MethodParameterEntryEvent[] entryStack = threadInfo.getEntryEvents();
            for (int i = entryEventTop; i >= 0; --i) {
                MethodParameters parameters = entryStack[i].getParameters();
                int nrOfParams = parameters.getNrOfParameters();
                for (int j = 0; j < nrOfParams; ++j) {
                    if (!MethodInvocationStatisticCreator.checkParameter(parameters.getSpec(j).getName(), parameters.getParameter(j), specName, filterParameters)) continue;
                    long entryId = entryStack[i].getId();
                    MethodInvocationId id = new MethodInvocationId(entryId);
                    collector.addTotal(id, value);
                    if (i != entryEventTop) continue;
                    StackFrames stack = it.getStack();
                    MethodObject methodObject = stack.getMethod(stack.getNrOfFrames() - 1);
                    if (parameters.getMethod().getIndex() != methodObject.getIndex()) continue;
                    collector.addSelf(id, value);
                }
            }
            collector.add(value, SimpleInvocationDist.EMPTY);
        }
        return collector;
    }

    private static boolean checkParameter(String specName, Parameter parameter, String filterSpecName, Parameter[] filterParameters) {
        if (!filterSpecName.equals(specName)) {
            return false;
        }
        if (filterParameters == null) {
            return true;
        }
        for (int k = 0; k < filterParameters.length; ++k) {
            if (!filterParameters[k].equals(parameter)) continue;
            return true;
        }
        return false;
    }
}

