/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.ThreadInfo;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.parameters.MethodParameters;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.snapshot.impl.resource.MptIteratorAdaptor;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfTotalAndOtherValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfTotalAndOtherStatisticCreator;
import com.sap.jvm.profiling.snapshot.resource.InvocationDist;
import com.sap.jvm.profiling.snapshot.resource.MptSpecName;
import com.sap.jvm.profiling.snapshot.resource.SimpleInvocationDist;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;
import java.util.HashSet;

public class MethodParameterStatisticCreator<V extends Value<V>>
extends SelfTotalAndOtherStatisticCreator<MptSpecName, V, InvocationDist> {
    @Override
    protected SelfTotalAndOtherValueStatisticCollector<MptSpecName, V, InvocationDist> getCollector(ValueIterator<V> rawIt) throws IOException {
        MptIteratorAdaptor<V> it = new MptIteratorAdaptor<V>(rawIt);
        SelfTotalAndOtherValueStatisticCollector<MptSpecName, V, SimpleInvocationDist> collector = new SelfTotalAndOtherValueStatisticCollector<MptSpecName, V, SimpleInvocationDist>(it.getEmptyValue(), SimpleInvocationDist.EMPTY);
        HashSet<String> seenSpecs = new HashSet<String>();
        while (it.next()) {
            ThreadInfo threadInfo;
            int entryEventTop;
            if (it.isEntry()) {
                MethodParameterEntryEvent entry = it.getEntryEvent();
                MethodParameters params = entry.getParameters();
                for (int i = params.getNrOfParameters() - 1; i >= 0; --i) {
                    MethodParameterSpec spec = params.getSpec(i);
                    SimpleInvocationDist dist = SimpleInvocationDist.getDist(entry);
                    collector.addOther(new MptSpecName(spec.getName()), dist);
                    collector.add(it.getEmptyValue(), dist);
                }
                continue;
            }
            if (it.isExit() || (entryEventTop = (threadInfo = it.getThreadInfo()).getEntryEventTop()) < 0) continue;
            V value = it.getValue();
            MethodParameterEntryEvent[] entryStack = threadInfo.getEntryEvents();
            for (int i = entryEventTop; i >= 0; --i) {
                MethodParameters parameters = entryStack[i].getParameters();
                int nrOfParams = parameters.getNrOfParameters();
                for (int j = 0; j < nrOfParams; ++j) {
                    MethodParameterSpec spec = parameters.getSpec(j);
                    String name = spec.getName();
                    if (seenSpecs.add(spec.getName())) {
                        collector.addTotal(new MptSpecName(name), value);
                    }
                    if (i != entryEventTop) continue;
                    StackFrames stack = it.getStack();
                    MethodObject methodObject = stack.getMethod(stack.getNrOfFrames() - 1);
                    if (parameters.getMethod().getIndex() != methodObject.getIndex()) continue;
                    collector.addSelf(new MptSpecName(name), value);
                }
            }
            collector.add(value, SimpleInvocationDist.EMPTY);
            seenSpecs.clear();
        }
        return collector;
    }
}

