/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.ValueStatisticCreator;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;

public class MethodTypeStatisticCreator<V extends Value<V>>
extends ValueStatisticCreator<MethodFilter, V> {
    private final MethodFilter[] filters;

    public MethodTypeStatisticCreator(MethodFilter[] filters) {
        this.filters = filters;
    }

    @Override
    protected ValueStatisticCollector<MethodFilter, V> getCollector(ValueIterator<V> it) throws IOException {
        ValueStatisticCollector collector = new ValueStatisticCollector(it.getEmptyValue());
        for (MethodFilter filter : this.filters) {
            collector.add(filter, it.getEmptyValue());
        }
        block1: while (it.next()) {
            StackFrames stack = it.getStack();
            int nrOfFrames = stack.getNrOfFrames();
            if (nrOfFrames <= 0) continue;
            MethodObject method = stack.getMethod(nrOfFrames - 1);
            Object value = it.getValue();
            for (MethodFilter filter : this.filters) {
                if (!filter.matches(method)) continue;
                collector.add(filter, value);
                collector.add(value);
                continue block1;
            }
        }
        return collector;
    }
}

