/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.ThreadInfo;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.parameters.MethodParameters;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByMethodParameter;
import com.sap.jvm.profiling.snapshot.impl.collections.EntryHashSet;
import com.sap.jvm.profiling.snapshot.impl.resource.MptIteratorAdaptor;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collector.EntrySorter;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfTotalAndOtherValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfTotalAndOtherStatisticCreator;
import com.sap.jvm.profiling.snapshot.resource.InvocationDist;
import com.sap.jvm.profiling.snapshot.resource.SimpleInvocationDist;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;
import java.util.HashSet;

public class ParameterValuesStatisticCreator<V extends Value<V>>
extends SelfTotalAndOtherStatisticCreator<Parameter, V, InvocationDist> {
    @Override
    protected SelfTotalAndOtherValueStatisticCollector<Parameter, V, InvocationDist> getCollector(ValueIterator<V> rawIt) throws IOException {
        ResourceName name = rawIt.getResourceName();
        MptIteratorAdaptor<V> it = new MptIteratorAdaptor<V>(rawIt);
        SelfTotalAndOtherValueStatisticCollector<Parameter, V, SimpleInvocationDist> collector = new SelfTotalAndOtherValueStatisticCollector<Parameter, V, SimpleInvocationDist>(it.getEmptyValue(), SimpleInvocationDist.EMPTY);
        HashSet<Parameter> seenValues = new HashSet<Parameter>();
        String specName = null;
        ResourceNameElement[] elements = name.getElements();
        for (int i = elements.length - 1; i >= 0; --i) {
            if (!(elements[i] instanceof FilterByMethodParameter)) continue;
            specName = ((FilterByMethodParameter)elements[i]).getMethodParameterName();
            break;
        }
        assert (specName != null);
        while (it.next()) {
            ThreadInfo threadInfo;
            int entryEventTop;
            if (it.isEntry()) {
                MethodParameterEntryEvent entry = it.getEntryEvent();
                MethodParameters params = entry.getParameters();
                for (int i = params.getNrOfParameters() - 1; i >= 0; --i) {
                    MethodParameterSpec spec = params.getSpec(i);
                    if (!specName.equals(spec.getName())) continue;
                    SimpleInvocationDist dist = SimpleInvocationDist.getDist(entry);
                    collector.addOther(params.getParameter(i), dist);
                    collector.add(it.getEmptyValue(), dist);
                }
                continue;
            }
            if (it.isExit() || (entryEventTop = (threadInfo = it.getThreadInfo()).getEntryEventTop()) < 0) continue;
            V value = it.getValue();
            MethodParameterEntryEvent[] entryStack = threadInfo.getEntryEvents();
            for (int i = entryEventTop; i >= 0; --i) {
                MethodParameters parameters = entryStack[i].getParameters();
                int nrOfParams = parameters.getNrOfParameters();
                for (int j = 0; j < nrOfParams; ++j) {
                    MethodParameterSpec spec = parameters.getSpec(j);
                    Parameter param = parameters.getParameter(j);
                    if (!specName.equals(spec.getName())) continue;
                    if (seenValues.add(param)) {
                        collector.addTotal(param, value);
                    }
                    if (i != entryEventTop) continue;
                    StackFrames stack = it.getStack();
                    MethodObject methodObject = stack.getMethod(stack.getNrOfFrames() - 1);
                    if (parameters.getMethod().getIndex() != methodObject.getIndex()) continue;
                    collector.addSelf(param, value);
                }
            }
            collector.add(it.getValue(), SimpleInvocationDist.EMPTY);
            seenValues.clear();
        }
        collector.setSorter(new EntrySorter<Parameter>(){

            @Override
            public void sort(EntryHashSet.Entry<Parameter>[] entries) {
                int insertPos = 0;
                for (int i = 0; i < entries.length; ++i) {
                    if (!entries[i].getKey().isErrorType()) continue;
                    EntryHashSet.Entry<Parameter> old = entries[insertPos];
                    entries[insertPos] = entries[i];
                    entries[i] = old;
                    ++insertPos;
                }
            }
        });
        return collector;
    }
}

