/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.CreatorUtils;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.util.threads.ResultList;
import com.sap.jvm.util.threads.VoidRunnable;
import java.io.IOException;

public abstract class ValueStatisticCreator<K, V extends Value<V>> {
    public void fillInStatistic(ValueStatisticImpl<K, V> statistic, ValueIterator<V>[] its) throws IOException {
        ResultList results = new ResultList();
        for (final ValueIterator<V> it : its) {
            results.add(new VoidRunnable<ValueStatisticCollector<K, V>>(){

                public ValueStatisticCollector<K, V> run() throws Exception {
                    return ValueStatisticCreator.this.getCollector(it);
                }
            });
        }
        this.combineCollectors(results, its[0].getResourceName()).fillStatistic(statistic);
        statistic.setDependent(its[0].getDependent());
    }

    public void fillInStatistic(ValueStatisticImpl<K, V> statistic, ValueIterator<V> it) throws IOException {
        this.getCollector(it).fillStatistic(statistic);
    }

    protected abstract ValueStatisticCollector<K, V> getCollector(ValueIterator<V> var1) throws IOException;

    protected final ValueStatisticCollector<K, V> combineCollectors(ResultList<ValueStatisticCollector<K, V>> list, ResourceName name) throws IOException {
        if (list.getThrowable() instanceof OperationCanceledException) {
            throw (OperationCanceledException)list.getThrowable();
        }
        if (list.getThrowable() != null) {
            CreatorUtils.traceCreationError(name, list.getThrowable());
        }
        if (list.getResult(0) == null) {
            throw new OperationCanceledException();
        }
        for (int i = 1; i < list.size(); ++i) {
            if (list.getResult(i) == null) {
                throw new OperationCanceledException();
            }
            ((ValueStatisticCollector)list.getResult(0)).add((ValueStatisticCollector)list.getResult(i));
        }
        return (ValueStatisticCollector)list.getResult(0);
    }
}

