/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueTreeBaseImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.Pruner;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueTreeCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.CreatorUtils;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.snapshot.util.ValueTreeNode;
import com.sap.jvm.util.threads.ResultList;
import com.sap.jvm.util.threads.VoidRunnable;
import java.io.IOException;

public abstract class ValueTreeCreator<K, V extends Value<V>> {
    public void fillIn(Pruner<V> pruner, ValueTreeBaseImpl<K, V, ValueTreeNode<K, V>> tree, ValueIterator<V> ... its) throws IOException {
        ResultList results = new ResultList();
        for (final ValueIterator<V> it : its) {
            results.add(new VoidRunnable<ValueTreeCollector<K, V>>(){

                public ValueTreeCollector<K, V> run() throws Exception {
                    return ValueTreeCreator.this.getChildCollector(it, null);
                }
            });
        }
        this.combine(results, pruner, null, its[0].getResourceName());
        tree.init(this.convertRoots((ValueTreeNodeImpl[])((ValueTreeCollector)results.get(0).getResult()).getRootNodes(null)), (Value)((ValueTreeCollector)results.get(0).getResult()).getTotal());
        tree.setDependent(its[0].getDependent());
    }

    protected ValueTreeNodeImpl<K, V>[] convertRoots(ValueTreeNodeImpl<K, V>[] roots) {
        return roots;
    }

    public void setChildren(Pruner<V> pruner, final ValueTreeNodeImpl<K, V> startNode, ValueIterator<V> ... its) throws IOException {
        ResultList results = new ResultList();
        for (final ValueIterator<V> it : its) {
            results.add(new VoidRunnable<ValueTreeCollector<K, V>>(){

                public ValueTreeCollector<K, V> run() throws Exception {
                    return ValueTreeCreator.this.getChildCollector(it, startNode);
                }
            });
        }
        startNode.setChildren(this.combine(results, pruner, startNode, its[0].getResourceName()).getRootNodes(startNode));
    }

    public void setSubNodes(Pruner<V> pruner, final ValueTreeNodeImpl<K, V> startNode, ValueIterator<V> ... its) throws IOException {
        ResultList results = new ResultList();
        for (final ValueIterator<V> it : its) {
            results.add(new VoidRunnable<ValueTreeCollector<K, V>>(){

                public ValueTreeCollector<K, V> run() throws Exception {
                    return ValueTreeCreator.this.getSubNodeCollector(it, startNode);
                }
            });
        }
        startNode.setSubNodes(this.combine(results, pruner, startNode, its[0].getResourceName()).getRootNodes(startNode));
    }

    protected abstract ValueTreeCollector<K, V> getChildCollector(ValueIterator<V> var1, ValueTreeNodeImpl<K, V> var2) throws IOException;

    protected ValueTreeCollector<K, V> getSubNodeCollector(ValueIterator<V> it, ValueTreeNodeImpl<K, V> startNode) throws IOException {
        throw new IllegalStateException("Not implemented");
    }

    protected final ValueTreeCollector<K, V> combine(ResultList<ValueTreeCollector<K, V>> list, Pruner<V> pruner, ValueTreeNodeImpl<K, V> startNode, ResourceName name) throws IOException {
        if (list.getThrowable() instanceof OperationCanceledException) {
            throw (OperationCanceledException)list.getThrowable();
        }
        if (list.getThrowable() != null) {
            CreatorUtils.traceCreationError(name, list.getThrowable());
        }
        if (list.getResult(0) == null) {
            throw new OperationCanceledException();
        }
        for (int i = 1; i < list.size(); ++i) {
            if (list.getResult(i) == null) {
                throw new OperationCanceledException();
            }
            ((ValueTreeCollector)list.getResult(0)).add((ValueTreeCollector)list.getResult(i), startNode);
        }
        ((ValueTreeCollector)list.getResult(0)).prune(pruner, startNode == null ? 0 : startNode.getDepth());
        return (ValueTreeCollector)list.getResult(0);
    }
}

