/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.series;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.BasicResourceReader;
import com.sap.jvm.profiling.resource.BasicResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.series.DataConverter;
import com.sap.jvm.profiling.snapshot.impl.util.series.DataXYListBuilder;
import com.sap.jvm.profiling.snapshot.impl.util.series.FileCollection;
import com.sap.jvm.profiling.snapshot.impl.util.series.FileCollectionCreator;
import com.sap.jvm.profiling.snapshot.impl.util.series.Uint16BasedDataXYList;
import com.sap.jvm.profiling.snapshot.impl.util.series.Uint16BasedXYList;
import com.sap.jvm.profiling.snapshot.impl.util.series.WritableTimeSeries;
import com.sap.jvm.profiling.snapshot.impl.util.series.XEventListBuilder;
import com.sap.jvm.profiling.snapshot.impl.util.series.XEventListImpl;
import com.sap.jvm.profiling.snapshot.impl.util.series.XYListBuilder;
import com.sap.jvm.profiling.snapshot.util.TimeSeriesCollection;
import com.sap.jvm.profiling.util.dataset.TimeSeries;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public abstract class AbstractTimeSeriesCollection
extends AbstractResource
implements TimeSeriesCollection {
    private static final int VERSION = 1;
    protected static final int XY_LIST = 0;
    protected static final int DATA_XY_LIST = 1;
    protected static final int X_EVENT_LIST = 2;
    protected XYListBuilder[] builders;
    protected DataXYListBuilder[] dataBuilders;
    protected XEventListBuilder[] eventBuilders;
    private WritableTimeSeries[] series;
    private final File filename;
    private final File dataFilename;

    protected AbstractTimeSeriesCollection(ResourceName name) throws IOException {
        super(name);
        this.filename = this.getFileName(false);
        this.dataFilename = this.getFileName(true);
        int[] listTypes = this.getListTypes();
        this.builders = new XYListBuilder[listTypes.length];
        this.dataBuilders = new DataXYListBuilder[listTypes.length];
        this.eventBuilders = new XEventListBuilder[listTypes.length];
        this.series = new WritableTimeSeries[listTypes.length];
        for (int i = 0; i < listTypes.length; ++i) {
            if (listTypes[i] == 0) {
                this.builders[i] = new XYListBuilder(this.getFileName(i));
                continue;
            }
            if (listTypes[i] == 1) {
                this.dataBuilders[i] = new DataXYListBuilder(this.getFileName(i), this.getDataFileName(i), this.getConverter(i));
                continue;
            }
            if (listTypes[i] != 2) continue;
            this.eventBuilders[i] = new XEventListBuilder(this.getFileName(i), this.getConverter(i));
        }
    }

    protected AbstractTimeSeriesCollection(ResourceName name, ResourceReader reader, ProgressReporter reporter, String message) throws IOException {
        super(name);
        int i;
        reader.readVersion(1);
        long work = reader.readInt64();
        long dataWork = reader.readInt64();
        reporter.addWork(message, work + dataWork);
        this.filename = this.getFileName(false);
        this.dataFilename = this.getFileName(true);
        FileOutputStream fos = new FileOutputStream(this.filename);
        AbstractTimeSeriesCollection.copy(reader, fos, work, reporter);
        fos.close();
        fos = new FileOutputStream(this.dataFilename);
        AbstractTimeSeriesCollection.copy(reader, fos, dataWork, reporter);
        fos.close();
        FileCollection fileCollection = new FileCollection(this.filename);
        FileCollection dataFileCollection = new FileCollection(this.dataFilename);
        int nrOfSeries = reader.readInt32();
        this.series = new WritableTimeSeries[nrOfSeries];
        int[] listTypes = this.getListTypes();
        if (nrOfSeries != listTypes.length) {
            throw new IOException("Expected " + listTypes.length + " but got " + nrOfSeries);
        }
        for (i = 0; i < nrOfSeries; ++i) {
            int type = reader.readInt32();
            if (type == listTypes[i]) continue;
            throw new IOException("Expected type " + listTypes[i] + " but got " + type);
        }
        for (i = 0; i < nrOfSeries; ++i) {
            if (listTypes[i] == 0) {
                this.series[i] = new Uint16BasedXYList(fileCollection, (BasicResourceReader)reader, reporter);
                continue;
            }
            if (listTypes[i] == 1) {
                this.series[i] = new Uint16BasedDataXYList(fileCollection, dataFileCollection, this.getConverter(i), (BasicResourceReader)reader, reporter);
                continue;
            }
            if (listTypes[i] == 2) {
                this.series[i] = new XEventListImpl(fileCollection, this.getConverter(i), (BasicResourceReader)reader, reporter);
                continue;
            }
            throw new IOException("Got unknown type " + listTypes[i] + " for index " + i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convert(ProgressReporter reporter) throws IOException {
        long work = 0L;
        for (XYListBuilder xYListBuilder : this.builders) {
            if (xYListBuilder == null) continue;
            work += (long)xYListBuilder.getSize();
        }
        for (XYListBuilder xYListBuilder : this.dataBuilders) {
            if (xYListBuilder == null) continue;
            work += (long)xYListBuilder.getSize();
        }
        reporter.setWork(I18n._s((String)"Compacting the graphs... (<%> %)"), work);
        FileCollectionCreator fcc = new FileCollectionCreator(this.filename, this.series.length);
        FileCollectionCreator dfcc = new FileCollectionCreator(this.dataFilename, this.series.length);
        for (int i = 0; i < this.series.length; ++i) {
            XEventListBuilder eventBuilder;
            DataXYListBuilder dataBuilder;
            XYListBuilder xYListBuilder = this.builders[i];
            if (xYListBuilder != null) {
                try {
                    this.series[i] = new Uint16BasedXYList(fcc.getWriter(i), xYListBuilder, reporter);
                }
                finally {
                    xYListBuilder.close();
                }
            }
            if ((dataBuilder = this.dataBuilders[i]) != null) {
                try {
                    this.series[i] = new Uint16BasedDataXYList(fcc.getWriter(i), dfcc.getWriter(i), dataBuilder, reporter);
                }
                finally {
                    dataBuilder.close();
                }
            }
            if ((eventBuilder = this.eventBuilders[i]) == null) continue;
            this.series[i] = new XEventListImpl(fcc.getWriter(i), eventBuilder);
        }
        fcc.finish();
        dfcc.finish();
        FileCollection collection = new FileCollection(this.filename);
        FileCollection fileCollection = new FileCollection(this.dataFilename);
        for (int i = 0; i < this.series.length; ++i) {
            this.series[i].assignFile(collection, i, fileCollection, i);
        }
        this.builders = null;
        this.dataBuilders = null;
        this.eventBuilders = null;
    }

    protected abstract int[] getListTypes();

    protected abstract DataConverter getConverter(int var1);

    private File getFileName(int index) {
        ResourceManager manager = this.getResourceName().getResourceManager();
        String prefix = manager.getAddonPrefix(this.getResourceName());
        return new File(prefix + "-" + index + ".dat");
    }

    private File getFileName(boolean isData) {
        ResourceManager manager = this.getResourceName().getResourceManager();
        String prefix = manager.getAddonPrefix(this.getResourceName());
        return new File(prefix + (isData ? "-data" : "") + ".dat");
    }

    private File getDataFileName(int index) {
        ResourceManager manager = this.getResourceName().getResourceManager();
        String prefix = manager.getAddonPrefix(this.getResourceName());
        return new File(prefix + "-data-" + index + ".dat");
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        long len = this.filename.length();
        long dataLen = this.dataFilename.length();
        writer.writeInt64(len);
        writer.writeInt64(dataLen);
        AbstractTimeSeriesCollection.copy(new RandomAccessFile(this.filename, "r"), writer, len, reporter);
        AbstractTimeSeriesCollection.copy(new RandomAccessFile(this.dataFilename, "r"), writer, dataLen, reporter);
        writer.writeInt32(this.series.length);
        for (int type : this.getListTypes()) {
            writer.writeInt32(type);
        }
        for (WritableTimeSeries list : this.series) {
            list.write((BasicResourceWriter)writer, reporter);
        }
    }

    @Override
    public long calculateWriteWork() {
        return this.filename.length() + this.dataFilename.length();
    }

    @Override
    public int getNrOfTimeSeries() {
        return this.series.length;
    }

    @Override
    public TimeSeries getTimeSeries(int index) {
        return this.series[index];
    }

    public boolean isModifiable() {
        return false;
    }

    public ResourceName[] getDependents() {
        return null;
    }

    private static void copy(ResourceReader reader, OutputStream os, long size, ProgressReporter reporter) throws IOException {
        byte[] buffer = new byte[(int)Math.min(size, 8192L)];
        int chunk = buffer.length;
        long left = size;
        while (left > 0L) {
            reader.readBytes(buffer, 0, chunk);
            os.write(buffer, 0, chunk);
            reporter.reportWorkOrThrow((long)chunk);
            chunk = (int)Math.min((long)chunk, left -= (long)chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(RandomAccessFile file, ResourceWriter writer, long size, ProgressReporter reporter) throws IOException {
        try {
            byte[] buffer = new byte[(int)Math.min(size, 8192L)];
            int chunk = buffer.length;
            long left = size;
            while (left > 0L) {
                file.readFully(buffer, 0, chunk);
                writer.writeBytes(buffer, 0, chunk);
                reporter.reportWorkOrThrow((long)chunk);
                chunk = (int)Math.min((long)chunk, left -= (long)chunk);
            }
        }
        finally {
            file.close();
        }
    }
}

