/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.series;

import com.sap.jvm.profiling.core.command.ChangeHeartBeatIntervalCommand;
import com.sap.jvm.profiling.core.event.HeartBeatEvent;
import com.sap.jvm.profiling.core.event.HeartBeatEventHandler;
import com.sap.jvm.profiling.core.response.ChangeHeartBeatIntervalResponse;
import com.sap.jvm.profiling.core.response.DisableHeartBeatResponse;
import com.sap.jvm.profiling.core.response.EnableHeartBeatResponse;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.impl.resource.BasicValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.series.AbstractTimeSeriesCollection;
import com.sap.jvm.profiling.snapshot.impl.util.series.DataConverter;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;
import java.lang.reflect.Field;

public abstract class AbstractValueTimeSeriesCollection<V extends Value<V>>
extends AbstractTimeSeriesCollection
implements HeartBeatEventHandler {
    private HeartBeatEvent currentHeartBeat;
    private HeartBeatEvent lastHeartBeat;
    private V curr;
    private V lastValue;
    private V emptyValue;
    private long[] values;
    private IOException currException;
    private long profilingStartupTimeStamp;
    private long heartbeatTime = -1L;

    protected AbstractValueTimeSeriesCollection(ResourceName name) throws IOException {
        super(name);
        this.profilingStartupTimeStamp = name.getSession().getSystemInfo().getTimeMillis();
    }

    protected AbstractValueTimeSeriesCollection(ResourceName name, ResourceReader reader, ProgressReporter reporter, String message) throws IOException {
        super(name, reader, reporter, message);
    }

    protected void createTimeSeries(BasicValueIterator<V> it) throws IOException {
        try {
            this.values = new long[this.getNrOfTimeSeries()];
            this.curr = null;
            this.currentHeartBeat = null;
            this.currException = null;
            this.emptyValue = it.getEmptyValue();
            this.lastValue = null;
            it.getEventReader().registerHeartBeatEventHandler((HeartBeatEventHandler)this);
            while (it.next()) {
                if (this.curr == null) {
                    this.curr = it.getEmptyValue();
                }
                V value = it.getValue();
                this.curr = this.curr.getSum(value);
                this.handleValue(value);
            }
        }
        finally {
            this.curr = null;
            this.emptyValue = null;
            this.lastValue = null;
            this.convert(it.getReporter());
            if (this.currException != null) {
                throw this.currException;
            }
        }
    }

    protected void handleValue(V value) {
    }

    protected boolean isHeartBeatBased(int index) {
        return true;
    }

    protected abstract void getValuesForValue(long[] var1, long var2, V var4);

    protected long getProfilingStart() {
        return this.profilingStartupTimeStamp;
    }

    protected long getFirstHeartBeat() {
        return this.heartbeatTime;
    }

    public void handle(EnableHeartBeatResponse response) {
    }

    public void handle(DisableHeartBeatResponse response) {
    }

    public void handle(ChangeHeartBeatIntervalCommand response) {
    }

    public void handle(ChangeHeartBeatIntervalResponse response) {
    }

    public void handle(HeartBeatEvent event) {
        if (this.heartbeatTime == -1L) {
            this.heartbeatTime = event.getTimeMillis();
        }
        if (this.currentHeartBeat != null && (this.curr != null || this.lastValue != null)) {
            if (this.lastHeartBeat != null && this.lastValue == null) {
                V tmp = this.curr;
                this.curr = null;
                this.calculateValues(this.currentHeartBeat, this.lastHeartBeat);
                this.curr = tmp;
            }
            this.calculateValues(event, this.currentHeartBeat);
            this.lastValue = this.curr;
            this.curr = null;
        }
        this.lastHeartBeat = this.currentHeartBeat;
        this.currentHeartBeat = event;
    }

    private void calculateValues(HeartBeatEvent current, HeartBeatEvent previous) {
        long timestamp = (current.getTimeMillis() - this.profilingStartupTimeStamp) * 1000L;
        long elapsed = current.getTimeMillis() - previous.getTimeMillis();
        this.getValuesForValue(this.values, elapsed, this.curr != null ? this.curr : this.emptyValue);
        try {
            for (int i = 0; i < this.builders.length; ++i) {
                if (!this.isHeartBeatBased(i)) continue;
                this.builders[i].add(timestamp, this.values[i]);
            }
        }
        catch (IOException e) {
            this.currException = e;
        }
    }

    @Override
    protected int[] getListTypes() {
        int nrOfSeries = 0;
        try {
            Field nrOfSeriesField = this.getClass().getField("NR_OF_SERIES");
            nrOfSeries = nrOfSeriesField.getInt(null);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        int[] result = new int[nrOfSeries];
        for (int i = 0; i < result.length; ++i) {
            result[i] = 0;
        }
        return result;
    }

    @Override
    protected DataConverter getConverter(int index) {
        return null;
    }
}

