/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.series;

import com.sap.jvm.profiling.snapshot.impl.util.series.DataConverter;
import com.sap.jvm.profiling.snapshot.impl.util.series.XYListBuilder;
import com.sap.jvm.tracing.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DataXYListBuilder
extends XYListBuilder {
    private final File dataFilename;
    private DataOutputStream ddos;
    private DataInputStream ddis;
    private final DataConverter converter;

    public DataXYListBuilder(File filename, File dataFilename, DataConverter converter) throws IOException {
        super(filename);
        this.dataFilename = dataFilename;
        this.converter = converter;
        this.ddos = new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream((OutputStream)new FileOutputStream(dataFilename + ".gz"), new Deflater(1, false))));
    }

    public void add(long x, long y, boolean empazised, Object data) throws IOException {
        byte[] bytes;
        if (!super.add(x, y)) {
            return;
        }
        this.dos.writeByte(empazised ? 1 : 0);
        byte[] byArray = bytes = data == null ? new byte[]{} : this.converter.convert(data);
        if (bytes.length < 255) {
            this.ddos.writeByte((byte)bytes.length);
        } else {
            this.ddos.writeByte(-1);
            this.ddos.writeInt(bytes.length);
        }
        this.ddos.write(bytes);
    }

    public File getDataFilename() {
        return this.dataFilename;
    }

    public DataInputStream getDataInputStream() throws IOException {
        this.ddos.close();
        this.ddos = null;
        this.ddis = new DataInputStream(new BufferedInputStream(new InflaterInputStream(new FileInputStream(this.dataFilename + ".gz"), new Inflater(false))));
        return this.ddis;
    }

    @Override
    public void close() {
        super.close();
        try {
            if (this.ddos != null) {
                this.ddos.close();
            }
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, (String)"Could not close");
        }
        try {
            if (this.ddis != null) {
                this.ddis.close();
            }
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, (String)"Could not close");
        }
        new File(this.dataFilename + ".gz").delete();
    }

    public DataConverter getConverter() {
        return this.converter;
    }
}

