/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.series;

import com.sap.jvm.profiling.util.io.RandomAccessFileInputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;

public class FileCollection {
    private static int availableSpace = 0x1400000;
    private static int minimalConcurrent = 20;
    private static ArrayList<Array<?>> arrays = new ArrayList();
    private final File filename;
    private final int nrOfFiles;

    public FileCollection(File filename) throws IOException {
        this.filename = filename;
        try (RandomAccessFile file = null;){
            file = new RandomAccessFile(filename, "r");
            if (file.read() != 1) {
                throw new IOException("FileCollection not marked as valid");
            }
            this.nrOfFiles = file.readInt();
        }
    }

    private static synchronized void addLoaded(Array<?> array) {
        int len = array.len;
        availableSpace -= len;
        if (arrays.size() > minimalConcurrent) {
            while (availableSpace < 0 && arrays.size() > 0) {
                int toRemove = (int)(Math.random() * (double)arrays.size());
                arrays.get(toRemove).clearData();
            }
        }
        arrays.add(array);
        ((Array)array).id = FileCollection.arrays.size() - 1;
    }

    private static synchronized void removeLoaded(Array<?> array) {
        availableSpace += array.len;
        arrays.set(((Array)array).id, arrays.get(arrays.size() - 1));
        ((Array)arrays.get(((Array)array).id)).id = ((Array)array).id;
        arrays.remove(arrays.size() - 1);
    }

    public DataInputStream getInputStream(int index, int offset) throws IOException {
        RandomAccessFile file = new RandomAccessFile(this.filename, "r");
        file.seek(5L + (long)index * 16L);
        long fileOffset = file.readLong();
        file.seek(fileOffset);
        DataInputStream result = new DataInputStream(new BufferedInputStream(new GZIPInputStream((InputStream)new RandomAccessFileInputStream(file))));
        result.skip(offset);
        return result;
    }

    public Array<char[]> getCharArray(int index, int offset, int len) {
        return new Array<char[]>(index, offset, len){

            @Override
            protected char[] createData(DataInputStream dis) throws IOException {
                char[] result = new char[this.len];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = dis.readChar();
                }
                return result;
            }
        };
    }

    public Array<int[]> getIntArray(int index, int offset, int len) {
        return new Array<int[]>(index, offset, len){

            @Override
            protected int[] createData(DataInputStream dis) throws IOException {
                int[] result = new int[this.len];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = dis.readInt();
                }
                return result;
            }
        };
    }

    public Array<long[]> getLongArray(int index, int offset, int len) {
        return new Array<long[]>(index, offset, len){

            @Override
            protected long[] createData(DataInputStream dis) throws IOException {
                long[] result = new long[this.len];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = dis.readLong();
                }
                return result;
            }
        };
    }

    public abstract class Array<T> {
        protected final int offset;
        protected final int len;
        protected final int index;
        private int id;
        protected T data;

        protected Array(int index, int offset, int len) {
            if (index < 0 || index >= FileCollection.this.nrOfFiles) {
                throw new RuntimeException("Invalid index " + index + " (max files " + FileCollection.this.nrOfFiles + ")");
            }
            this.offset = offset;
            this.len = len;
            this.index = index;
        }

        public final synchronized T getContent() {
            if (this.data == null) {
                FilterInputStream dis = null;
                try {
                    dis = FileCollection.this.getInputStream(this.index, this.offset);
                    this.data = this.createData((DataInputStream)dis);
                    FileCollection.addLoaded(this);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            return this.data;
        }

        public synchronized void clearData() {
            if (this.data != null) {
                this.data = null;
                FileCollection.removeLoaded(this);
            }
        }

        protected abstract T createData(DataInputStream var1) throws IOException;

        public void finalize() {
            this.clearData();
        }
    }
}

