/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.series;

import com.sap.jvm.profiling.util.io.RandomAccessFileOutputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.GZIPOutputStream;

public class FileCollectionCreator {
    private final RandomAccessFile file;
    private final int nrOfFiles;
    private DataOutputStream writer;
    private int writerIndex;
    private long start;

    public FileCollectionCreator(File baseName, int nrOfFiles) throws IOException {
        baseName.delete();
        this.file = new RandomAccessFile(baseName, "rw");
        this.file.write(0);
        this.file.writeInt(nrOfFiles);
        this.nrOfFiles = nrOfFiles;
        for (int i = 0; i < nrOfFiles; ++i) {
            this.file.writeLong(-1L);
            this.file.writeLong(-1L);
        }
    }

    public void finish() throws IOException {
        this.finishWriter();
        this.file.seek(0L);
        this.file.write(1);
        this.file.close();
    }

    public DataOutputStream getWriter(int index) throws IOException {
        assert (index >= 0);
        assert (index < this.nrOfFiles);
        this.finishWriter();
        this.start = this.file.length();
        this.file.seek(this.start);
        this.writerIndex = index;
        this.writer = new DataOutputStream(new BufferedOutputStream(new BestSpeedGZIPOutputStream((OutputStream)new RandomAccessFileOutputStream(this.file, false))));
        return this.writer;
    }

    private void finishWriter() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
            long len = this.file.length() - this.start;
            this.file.seek(5 + 16 * this.writerIndex);
            this.file.writeLong(this.start);
            this.file.writeLong(len);
        }
    }

    private static class BestSpeedGZIPOutputStream
    extends GZIPOutputStream {
        public BestSpeedGZIPOutputStream(OutputStream out) throws IOException {
            super(out);
            this.def.setLevel(1);
        }
    }
}

