/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.series;

import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.inspector.jvmmon.MonitoringAttribute;
import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.alert.event.AlertEventHandler;
import com.sap.jvm.profiling.alert.event.AlertEventWithExceptionStack;
import com.sap.jvm.profiling.alert.event.ErrorEvent;
import com.sap.jvm.profiling.alert.event.OutOfMemoryEvent;
import com.sap.jvm.profiling.alert.event.SpuriousWackupEvent;
import com.sap.jvm.profiling.alert.event.StackoverflowEvent;
import com.sap.jvm.profiling.alert.event.StartAllocationAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StartClassStatisticAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StartDebuggingEvent;
import com.sap.jvm.profiling.alert.event.StartFileAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StartGarbageCollectionAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StartHeapDumpAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StartMethodParameterAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StartNetworkIoAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StartPerformanceHotspotAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StartProfilingEvent;
import com.sap.jvm.profiling.alert.event.StartSynchronizationAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StopAllocationAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StopClassStatisticAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StopDebuggingEvent;
import com.sap.jvm.profiling.alert.event.StopFileAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StopGarbageCollectionAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StopHeapDumpAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StopMethodParameterAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StopNetworkIoAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StopPerformanceHotspotAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StopProfilingEvent;
import com.sap.jvm.profiling.alert.event.StopSynchronizationAnalysisEvent;
import com.sap.jvm.profiling.alert.event.StorableAlert;
import com.sap.jvm.profiling.alert.event.ThreadStopEvent;
import com.sap.jvm.profiling.alert.event.TraceEventBase;
import com.sap.jvm.profiling.alert.event.TraceEventError;
import com.sap.jvm.profiling.alert.event.TraceEventInformation;
import com.sap.jvm.profiling.alert.event.TraceEventWarning;
import com.sap.jvm.profiling.alert.response.DisableAlertResponse;
import com.sap.jvm.profiling.alert.response.EnableAlertResponse;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.command.ChangeHeartBeatIntervalCommand;
import com.sap.jvm.profiling.core.event.HeartBeatEvent;
import com.sap.jvm.profiling.core.event.HeartBeatEventHandler;
import com.sap.jvm.profiling.core.event.HeartBeatGCStatistic;
import com.sap.jvm.profiling.core.event.ThreadAnnotationChanged;
import com.sap.jvm.profiling.core.event.ThreadEventHandler;
import com.sap.jvm.profiling.core.event.ThreadNameChanged;
import com.sap.jvm.profiling.core.event.ThreadStarted;
import com.sap.jvm.profiling.core.event.ThreadStopped;
import com.sap.jvm.profiling.core.event.ThreadUserChanged;
import com.sap.jvm.profiling.core.response.ChangeHeartBeatIntervalResponse;
import com.sap.jvm.profiling.core.response.DisableHeartBeatResponse;
import com.sap.jvm.profiling.core.response.EnableHeartBeatResponse;
import com.sap.jvm.profiling.core.type.ThreadManager;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcCause;
import com.sap.jvm.profiling.monitoring.event.MonitoringBoardDiffEvent;
import com.sap.jvm.profiling.monitoring.event.MonitoringBoardEvent;
import com.sap.jvm.profiling.monitoring.event.MonitoringEventHandler;
import com.sap.jvm.profiling.monitoring.response.DisableMonitoringBoardTraceResponse;
import com.sap.jvm.profiling.monitoring.response.EnableMonitoringBoardTraceResponse;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.util.series.AbstractTimeSeriesCollection;
import com.sap.jvm.profiling.snapshot.impl.util.series.DataConverter;
import com.sap.jvm.profiling.snapshot.impl.util.series.StringConverter;
import com.sap.jvm.profiling.snapshot.impl.util.series.XEventListBuilder;
import com.sap.jvm.profiling.snapshot.util.GeneralTimeSeries;
import com.sap.jvm.profiling.util.splitarray.SplitArray32;
import com.sap.jvm.profiling.util.splitarray.SplitArray64;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.pair.IntPair;
import com.sap.jvm.util.persistence.VersionMismatchException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GeneralTimeSeriesImpl
extends AbstractTimeSeriesCollection
implements GeneralTimeSeries,
HeartBeatEventHandler,
AlertEventHandler,
ThreadEventHandler,
MonitoringEventHandler {
    private static final int BOOKMARK_READ_BYTES_DISTANCE = 0x100000;
    private static final int VERSION = 1;
    private static final int HEART_BEAT_MEMORY_CACHE_SIZE = 50000;
    private long profilingStartupTimeStamp;
    private int memoryCacheLength = 0;
    private final long[] timestampCache = new long[50000];
    private final long[] memoryCache = new long[50000];
    private boolean lastHeartBeatIncludesGc = false;
    private final HashMap<Long, String> profilingSession2Text = new HashMap();
    private final HashMap<Long, Long> profilingSession2Start = new HashMap();
    private final HashMap<DebuggingSessionId, String> debuggingSession2Text = new HashMap();
    private final HashMap<DebuggingSessionId, Long> debuggingSession2Start = new HashMap();
    private long lastTimestamp = -1L;
    private long startTimeStamp;
    private long endTimeStamp;
    private long heartBeatInterval = 0L;
    private long threadCount = 0L;
    private boolean[] validThreads;
    private boolean firstHeartBeatInSnapshot = true;
    private ThreadManager threads;
    private ProfilingReader reader;
    private int nrOfBoards;
    private long lastNrOfReadBytesForBoardBookmark;
    private long lastNrOfReadBytesForBoard;
    private long lastTimeStampForBoard;
    private Bookmark lastBoardBookmark;
    private long lastTs;
    private long lastFileRead;
    private long lastFileWritten;
    private long lastSocketRead;
    private long lastSocketWritten;
    private ArrayList<Bookmark> bookmarks;
    private SplitArray64 bookmarkTimes;
    private SplitArray32 bookmarkIndices;
    private boolean hasAttributes;
    private MonitoringAttribute loadAvgAttr;
    private MonitoringAttribute codeCacheOccupancyAttr;
    private MonitoringAttribute codeCacheMaxOccupancyAttr;
    private MonitoringAttribute codeCacheTier1MethodsAttr;
    private MonitoringAttribute codeCacheTier2MethodsAttr;
    private MonitoringAttribute threadStatesAttr;
    private MonitoringAttribute cumThreadsAttr;
    private MonitoringAttribute nrProcesses;
    private MonitoringAttribute nrProcessesFailed;
    private MonitoringAttribute cumSafepointTime;
    private MonitoringAttribute maxSafepointTime;
    private MonitoringAttribute cumSafepointSyncTime;
    private MonitoringAttribute maxSafepointSyncTime;
    private MonitoringAttribute safepointCount;
    private MonitoringAttribute cumVmOperationTime;
    private MonitoringAttribute vmOperationCount;
    private MonitoringAttribute counterFreq;
    private MonitoringAttribute openFiles;
    private MonitoringAttribute openSockets;
    private MonitoringAttribute fileRead;
    private MonitoringAttribute fileWritten;
    private MonitoringAttribute socketRead;
    private MonitoringAttribute socketWritten;
    private MonitoringAttribute fileReadHistory;
    private MonitoringAttribute fileWriteHistory;
    private MonitoringAttribute socketReadHistory;
    private MonitoringAttribute socketWriteHistory;
    private MonitoringAttribute nativeMemAvailable;
    private MonitoringAttribute nativeMemReserved;
    private MonitoringAttribute workingSetSize;
    private MonitoringAttribute majorFaults;
    private MonitoringAttribute majorFaultsHistory;
    private MonitoringAttribute minorFaults;
    private MonitoringAttribute minorFaultsHistory;
    private MonitoringAttribute pageFaults;
    private MonitoringAttribute pageFaultsHistory;
    private MonitoringAttribute lockContention;
    private MonitoringAttribute lockContentionHistory;
    private MonitoringAttribute loadedClasses;
    private MonitoringAttribute unloadedClasses;
    private MonitoringAttribute loadedArrayClasses;
    private MonitoringAttribute unloadedArrayClasses;

    public GeneralTimeSeriesImpl(ResourceName name) throws IOException {
        super(name);
        this.bookmarks = new ArrayList();
        this.bookmarkTimes = new SplitArray64();
        this.bookmarkIndices = new SplitArray32();
        this.init();
    }

    public GeneralTimeSeriesImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reader, reporter, I18n._s((String)"Reading the general time series ... (<%> %)"));
        reader.readVersion(1);
        this.nrOfBoards = reader.readInt32();
        int nrOfBookmarks = reader.readInt32();
        this.bookmarks = new ArrayList(nrOfBookmarks);
        this.bookmarkTimes = new SplitArray64();
        this.bookmarkTimes.resize(nrOfBookmarks);
        this.bookmarkIndices = new SplitArray32();
        this.bookmarkIndices.resize(nrOfBookmarks);
        ProfilingSession session = name.getSession();
        for (int i = 0; i < nrOfBookmarks; ++i) {
            this.bookmarks.add(session.readBookmark(reader));
            this.bookmarkTimes.set((long)i, reader.readInt64());
            this.bookmarkIndices.set(i, reader.readInt32());
        }
        this.init();
    }

    private void init() {
        ProfilingSession session = this.getResourceName().getSession();
        this.profilingStartupTimeStamp = session.getSystemInfo().getTimeMillis();
        Snapshot snapshot = SnapshotResourceManagerFactory.get(session).getSnapshot(this.getResourceName());
        this.startTimeStamp = snapshot.getStartCollectionTimeStamp();
        this.endTimeStamp = snapshot.getEndCollectionTimeStamp();
        assert (this.endTimeStamp > 0L);
        assert (this.endTimeStamp >= this.startTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeneralTimeSeriesImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        ProfilingReader reader;
        GeneralTimeSeriesImpl result = new GeneralTimeSeriesImpl(name);
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        result.reader = reader = snapshot.getEventReader(reporter);
        try {
            reporter.setWork(I18n._s((String)"Creating the general time series ... (<%> %)"), reader.getNrOfPacketsToRead());
            reader.registerHeartBeatEventHandler((HeartBeatEventHandler)result);
            reader.registerAlertEventHandler((AlertEventHandler)result);
            reader.registerThreadEventHandler((ThreadEventHandler)result);
            reader.registerMonitoringEventHandler((MonitoringEventHandler)result);
            result.threads = reader.getThreadManager();
            result.validThreads = new boolean[Math.max(512, reader.getThreadManager().getMaxIndex() + '\u0001')];
            while (reader.nextPacket() != null) {
                reporter.reportNextOrThrow();
            }
        }
        finally {
            reader.close();
            result.reader = null;
        }
        result.flushMemoryCache(result.memoryCacheLength);
        result.flushOpenConnections();
        result.convert(reporter);
        return result;
    }

    @Override
    protected int[] getListTypes() {
        int[] result = new int[]{0, 1, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        assert (result.length == 49);
        return result;
    }

    @Override
    protected DataConverter getConverter(int index) {
        if (index == 1) {
            return new HeartBeatGCStatisticConverter();
        }
        if (index == 5 || index == 6 || index == 7 || index == 8 || index == 9) {
            return new StringConverter();
        }
        return null;
    }

    private boolean timestampOutsideSnapshot(long time) {
        return time < this.startTimeStamp - this.heartBeatInterval || time > this.endTimeStamp + this.heartBeatInterval;
    }

    public void handle(EnableHeartBeatResponse response) {
        this.heartBeatInterval = response.getInterval();
    }

    public void handle(DisableHeartBeatResponse response) {
    }

    public void handle(ChangeHeartBeatIntervalCommand response) {
    }

    public void handle(ChangeHeartBeatIntervalResponse response) {
    }

    public void handle(HeartBeatEvent event) {
        try {
            if (this.timestampOutsideSnapshot(event.getTimeMillis())) {
                return;
            }
            long ts = (event.getTimeMillis() - this.profilingStartupTimeStamp) * 1000L;
            double f = 1.0E9 / (double)event.getEventElapsedTime();
            this.lastTimestamp = ts;
            this.builders[0].add(ts, (long)(event.getCPULoad() * 1000.0));
            this.handleMemory(event, ts);
            this.builders[2].add(ts, (long)(event.getCompileThreadsLoad() * 1000.0));
            long bytes = (long)((double)(event.getEventFileIOReadBytes() + event.getEventFileIOWrittenBytes()) * f);
            this.builders[3].add(ts, bytes);
            bytes = (long)((double)(event.getEventNetIOReadBytes() + event.getEventNetIOWrittenBytes()) * f);
            this.builders[4].add(ts, bytes);
            if (this.firstHeartBeatInSnapshot) {
                this.firstHeartBeatInSnapshot = false;
                this.threadCount = 0L;
                this.ensureValidThreadSize(this.threads.getMaxIndex());
                Arrays.fill(this.validThreads, false);
                for (char i = '\u0000'; i <= this.threads.getMaxIndex(); i = (char)(i + '\u0001')) {
                    this.validThreads[i] = this.threads.getThreadInfo(i).isValid();
                    if (!this.validThreads[i]) continue;
                    ++this.threadCount;
                }
            }
            this.builders[10].add(ts, this.threadCount);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleMemory(HeartBeatEvent event, long ts) throws IOException {
        HeartBeatGCStatistic[] gcStatistics = event.getGCStatistics();
        if (gcStatistics.length > 0) {
            int i;
            long gcTS = (gcStatistics[0].getTimeMillis() - this.profilingStartupTimeStamp) * 1000L;
            int removeCount = 0;
            if (gcTS > 0L) {
                if (this.lastHeartBeatIncludesGc && this.memoryCacheLength == 1) {
                    ++removeCount;
                }
                int last = this.memoryCacheLength - 1;
                while (last - removeCount >= 0 && gcTS < this.timestampCache[last - removeCount]) {
                    ++removeCount;
                }
            }
            this.flushMemoryCache(this.memoryCacheLength - removeCount);
            this.memoryCacheLength = 0;
            long[] timestamps = new long[2 * gcStatistics.length];
            long[] memory = new long[2 * gcStatistics.length];
            boolean[] emphasis = new boolean[2 * gcStatistics.length];
            HeartBeatGCStatistic[] stats = new HeartBeatGCStatistic[2 * gcStatistics.length];
            boolean[] skipped = new boolean[2 * gcStatistics.length];
            for (i = 0; i < gcStatistics.length; ++i) {
                gcTS = (gcStatistics[i].getTimeMillis() - this.profilingStartupTimeStamp) * 1000L;
                if (gcTS < 0L) continue;
                timestamps[2 * i] = gcTS;
                memory[2 * i] = (long)(100000.0 * (double)gcStatistics[i].getMemSizeBefore() / (double)event.getMemCapacity());
                emphasis[2 * i] = true;
                stats[2 * i] = gcStatistics[i];
                timestamps[2 * i + 1] = Math.min(gcTS + gcStatistics[i].getDuration(), ts - 1L);
                memory[2 * i + 1] = (long)(100000.0 * (double)gcStatistics[i].getMemSizeAfter() / (double)event.getMemCapacity());
                emphasis[2 * i + 1] = false;
                stats[2 * i + 1] = null;
            }
            for (i = timestamps.length - 1; i > 0; --i) {
                if (timestamps[i] >= timestamps[i - 1]) continue;
                if (stats[i - 1] == null && Math.abs(memory[i - 2] - memory[i - 1]) < 1000L) {
                    skipped[i - 1] = true;
                }
                timestamps[i - 1] = timestamps[i] - 1L;
            }
            for (i = 0; i < timestamps.length - 1; ++i) {
                if (skipped[i]) continue;
                this.dataBuilders[1].add(timestamps[i], memory[i], emphasis[i], stats[i]);
            }
            assert (!emphasis[emphasis.length - 1] && stats[stats.length - 1] == null);
            this.addToMemoryCache(timestamps[timestamps.length - 1], memory[memory.length - 1]);
        }
        this.lastHeartBeatIncludesGc = gcStatistics.length > 0;
        this.addToMemoryCache(ts, (long)(100000.0 * (double)event.getMemSize() / (double)event.getMemCapacity()));
    }

    private void addToMemoryCache(long ts, long memory) {
        if (this.memoryCacheLength >= this.memoryCache.length) {
            int flushCount = this.memoryCacheLength / 4;
            this.flushMemoryCache(flushCount);
            this.memoryCacheLength -= flushCount;
            System.arraycopy(this.timestampCache, flushCount, this.timestampCache, 0, this.memoryCacheLength);
            System.arraycopy(this.memoryCache, flushCount, this.memoryCache, 0, this.memoryCacheLength);
        }
        assert (this.memoryCacheLength < this.memoryCache.length);
        this.timestampCache[this.memoryCacheLength] = ts;
        this.memoryCache[this.memoryCacheLength] = memory;
        ++this.memoryCacheLength;
    }

    private void flushMemoryCache(int count) {
        assert (count <= this.memoryCacheLength);
        try {
            for (int i = 0; i < count; ++i) {
                this.dataBuilders[1].add(this.timestampCache[i], this.memoryCache[i], false, null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void handle(ErrorEvent event) {
        this.addAlert((AlertEventWithExceptionStack)event);
    }

    public void handle(OutOfMemoryEvent event) {
        this.addAlert((AlertEventWithExceptionStack)event);
    }

    public void handle(SpuriousWackupEvent event) {
        this.addTraceAlert((TraceEventBase)event, this.eventBuilders[6]);
    }

    public void handle(StackoverflowEvent event) {
        this.addAlert((AlertEventWithExceptionStack)event);
    }

    public void handle(ThreadStopEvent event) {
        this.addAlert((AlertEventWithExceptionStack)event);
    }

    public void handle(EnableAlertResponse response) {
    }

    public void handle(DisableAlertResponse response) {
    }

    public void handle(TraceEventError event) {
        this.addTraceAlert((TraceEventBase)event, this.eventBuilders[5]);
    }

    public void handle(TraceEventInformation response) {
        this.addTraceAlert((TraceEventBase)response, this.eventBuilders[7]);
    }

    public void handle(TraceEventWarning response) {
        this.addTraceAlert((TraceEventBase)response, this.eventBuilders[6]);
    }

    public void handle(StartProfilingEvent response) {
        if (response.wasSessionAlreadyActive()) {
            return;
        }
        long ts = (response.getTimeStamp() - this.profilingStartupTimeStamp) * 1000L;
        StringBuilder text = new StringBuilder("Started Profiling session");
        text.append(" (ID = ");
        text.append(response.getSessionId());
        text.append("; ");
        switch (response.getOutputBufferTyp()) {
            case 2: {
                text.append("debugging connection ");
            }
        }
        text.append(response.getClientIdentifier());
        text.append(')');
        assert (!this.profilingSession2Start.containsKey(response.getSessionId()));
        this.profilingSession2Start.put(response.getSessionId(), ts);
        assert (!this.profilingSession2Text.containsKey(response.getSessionId()));
        this.profilingSession2Text.put(response.getSessionId(), text.toString());
    }

    public void handle(StopProfilingEvent response) {
        if (!this.profilingSession2Start.containsKey(response.getSessionId()) || !this.profilingSession2Text.containsKey(response.getSessionId())) {
            return;
        }
        long start = this.profilingSession2Start.remove(response.getSessionId());
        String text = this.profilingSession2Text.remove(response.getSessionId());
        long end = (response.getTimeStamp() - this.profilingStartupTimeStamp) * 1000L;
        long duration = end - start;
        try {
            this.eventBuilders[8].add(start, duration, text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void handle(StartDebuggingEvent response) {
        if (response.wasSessionAlreadyActive()) {
            return;
        }
        long ts = (response.getTimeStamp() - this.profilingStartupTimeStamp) * 1000L;
        StringBuilder text = new StringBuilder("Started debugging session");
        text.append(" (");
        text.append(response.getClientIdentifier().toString());
        text.append(":");
        text.append(response.getPortNumber());
        text.append(')');
        DebuggingSessionId id = new DebuggingSessionId(response.getClientIdentifier(), response.getPortNumber());
        assert (!this.debuggingSession2Start.containsKey(id));
        this.debuggingSession2Start.put(id, ts);
        assert (!this.debuggingSession2Text.containsKey(id));
        this.debuggingSession2Text.put(id, text.toString());
    }

    public void handle(StopDebuggingEvent response) {
        DebuggingSessionId id = new DebuggingSessionId(response.getClientIdentifier(), response.getPortNumber());
        if (!this.debuggingSession2Start.containsKey(id) || !this.debuggingSession2Text.containsKey(id)) {
            return;
        }
        long start = this.debuggingSession2Start.remove(id);
        String text = this.debuggingSession2Text.remove(id);
        long end = (response.getTimeStamp() - this.profilingStartupTimeStamp) * 1000L;
        long duration = end - start;
        try {
            this.eventBuilders[9].add(start, duration, text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addAlert(AlertEventWithExceptionStack event) {
        if (this.timestampOutsideSnapshot(event.getTimeStamp())) {
            return;
        }
        long ts = (event.getTimeStamp() - this.profilingStartupTimeStamp) * 1000L;
        String msg = event.getExceptionMessage().toString().trim();
        StringBuilder text = new StringBuilder(event.getExceptionClass().getName());
        if (msg.length() > 0) {
            text.append('\n');
            text.append(msg);
        }
        try {
            if (event.getExceptionClass().getName().toLowerCase().contains("error")) {
                this.eventBuilders[5].add(ts, text.toString());
            } else {
                this.eventBuilders[6].add(ts, text.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addTraceAlert(TraceEventBase event, XEventListBuilder builder) {
        try {
            if (this.timestampOutsideSnapshot(event.getTimeStamp())) {
                return;
            }
            long ts = (event.getTimeStamp() - this.profilingStartupTimeStamp) * 1000L;
            builder.add(ts, event.getMessage().toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void flushOpenConnections() throws IOException {
        Iterator<Object> iterator = this.profilingSession2Start.keySet().iterator();
        while (iterator.hasNext()) {
            long id = iterator.next();
            if (!this.profilingSession2Text.containsKey(id)) continue;
            long start = this.profilingSession2Start.get(id);
            String text = this.profilingSession2Text.get(id);
            long duration = this.lastTimestamp - start;
            this.eventBuilders[8].add(start, duration >= 0L ? duration : 0L, text);
        }
        for (DebuggingSessionId id : this.debuggingSession2Start.keySet()) {
            if (!this.debuggingSession2Text.containsKey(id)) continue;
            long start = this.debuggingSession2Start.get(id);
            String text = this.debuggingSession2Text.get(id);
            long duration = this.lastTimestamp - start;
            this.eventBuilders[9].add(start, duration >= 0L ? duration : 0L, text);
        }
    }

    public void handle(StartAllocationAnalysisEvent response) {
    }

    public void handle(StartClassStatisticAnalysisEvent response) {
    }

    public void handle(StartFileAnalysisEvent response) {
    }

    public void handle(StartGarbageCollectionAnalysisEvent response) {
    }

    public void handle(StartHeapDumpAnalysisEvent response) {
    }

    public void handle(StartMethodParameterAnalysisEvent response) {
    }

    public void handle(StartNetworkIoAnalysisEvent response) {
    }

    public void handle(StartPerformanceHotspotAnalysisEvent response) {
    }

    public void handle(StartSynchronizationAnalysisEvent response) {
    }

    public void handle(StopAllocationAnalysisEvent response) {
    }

    public void handle(StopClassStatisticAnalysisEvent response) {
    }

    public void handle(StopFileAnalysisEvent response) {
    }

    public void handle(StopGarbageCollectionAnalysisEvent response) {
    }

    public void handle(StopHeapDumpAnalysisEvent response) {
    }

    public void handle(StopMethodParameterAnalysisEvent response) {
    }

    public void handle(StopNetworkIoAnalysisEvent response) {
    }

    public void handle(StopPerformanceHotspotAnalysisEvent response) {
    }

    public void handle(StopSynchronizationAnalysisEvent response) {
    }

    public void handle(StorableAlert event) {
        if (this.timestampOutsideSnapshot(event.getTimeStamp())) {
            return;
        }
        long ts = (event.getTimeStamp() - this.profilingStartupTimeStamp) * 1000L;
        String msg = event.getMessage().toString().trim();
        StringBuilder text = new StringBuilder(event.getDescription());
        if (msg.length() > 0) {
            text.append('\n');
            text.append(msg);
        }
        try {
            if (event.getSeverity() == 4) {
                this.eventBuilders[5].add(ts, text.toString());
            } else if (event.getSeverity() == 3) {
                this.eventBuilders[6].add(ts, text.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void handle(ThreadStarted event, ThreadManager threadManager) {
        this.ensureValidThreadSize(event.getThreadIndex());
        if (!this.validThreads[event.getThreadIndex()]) {
            this.validThreads[event.getThreadIndex()] = true;
            ++this.threadCount;
        }
    }

    public void handle(ThreadStopped event, ThreadManager threadManager) {
        this.ensureValidThreadSize(event.getThreadIndex());
        if (this.validThreads[event.getThreadIndex()]) {
            this.validThreads[event.getThreadIndex()] = false;
            --this.threadCount;
        }
    }

    private void ensureValidThreadSize(int index) {
        if (index >= this.validThreads.length) {
            boolean[] newThreads = new boolean[Math.max(2 * this.validThreads.length, index + 1)];
            System.arraycopy(this.validThreads, 0, newThreads, 0, this.validThreads.length);
            this.validThreads = newThreads;
        }
    }

    public void handle(ThreadUserChanged event, ThreadManager threadManager) {
    }

    public void handle(ThreadNameChanged event, ThreadManager threadManager) {
    }

    public void handle(ThreadAnnotationChanged event, ThreadManager threadManager) {
    }

    public void handle(EnableMonitoringBoardTraceResponse response) {
    }

    public void handle(DisableMonitoringBoardTraceResponse response) {
    }

    private void initAttributes(byte[] buffer) {
        if (!this.hasAttributes) {
            Map attributes;
            try {
                attributes = new BoardWrapper(buffer).getAllAttributes();
            }
            catch (MonitorBoardFormatException e) {
                return;
            }
            this.hasAttributes = true;
            MonitoringAttribute attr = (MonitoringAttribute)attributes.get("LOAD_AVERAGE");
            if (attr != null && attr.isDoubleArray() && attr.getLength(buffer) >= 3) {
                this.loadAvgAttr = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("CC_MAX_OCCUPANCY")) != null && attr.isLong()) {
                this.codeCacheMaxOccupancyAttr = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("CC_OCCUPANCY")) != null && attr.isLong()) {
                this.codeCacheOccupancyAttr = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("CC_NUM_NMETHODS_T1")) != null && attr.isInt()) {
                this.codeCacheTier1MethodsAttr = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("CC_NUM_NMETHODS_T2")) != null && attr.isInt()) {
                this.codeCacheTier2MethodsAttr = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("JAVA_THREAD_STATE")) != null && attr.isIntArray() && attr.getLength(buffer) >= 3) {
                this.threadStatesAttr = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("CUMMULATIVE_NUM_JAVA_THREADS")) != null && attr.isLong()) {
                this.cumThreadsAttr = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("CHILD_PROCESSES_CREATED")) != null && attr.isLong()) {
                this.nrProcesses = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("CHILD_PROCESSES_FAILED")) != null && attr.isLong()) {
                this.nrProcessesFailed = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("TIME_SAFEPOINTS")) != null && attr.isLong()) {
                this.cumSafepointTime = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("MAX_TIME_SAFEPOINT")) != null && attr.isLong()) {
                this.maxSafepointTime = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("SAFEPOINT_SYNC_TIME")) != null && attr.isLong()) {
                this.cumSafepointSyncTime = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("MAX_SAFEPOINT_SYNC_TIME")) != null && attr.isLong()) {
                this.maxSafepointSyncTime = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("NUM_SAFEPOINTS")) != null && attr.isInt()) {
                this.safepointCount = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("NUM_VM_OPS")) != null && attr.isInt()) {
                this.vmOperationCount = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("ELAPSEDTIME_VM_OPS")) != null && attr.isLong()) {
                this.cumVmOperationTime = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("CPU_COUNTER_FREQUENCY")) != null && attr.isLong()) {
                this.counterFreq = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("JAVA_THREADS_FILES_OPEN")) != null && attr.isInt()) {
                this.openFiles = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("JAVA_THREADS_SOCKETS_OPEN")) != null && attr.isInt()) {
                this.openSockets = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("JAVA_THREADS_FILE_READ")) != null && attr.isLong()) {
                this.fileRead = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("JAVA_THREADS_FILE_WRITTEN")) != null && attr.isLong()) {
                this.fileWritten = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("JAVA_THREADS_SOCKET_READ")) != null && attr.isLong()) {
                this.socketRead = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("JAVA_THREADS_SOCKET_WRITTEN")) != null && attr.isLong()) {
                this.socketWritten = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("JAVA_THREADS_FILE_READ_HISTORY_1_5_15")) != null && attr.isLongArray()) {
                this.fileReadHistory = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("JAVA_THREADS_FILE_WRITTEN_HISTORY_1_5_15")) != null && attr.isLongArray()) {
                this.fileWriteHistory = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("JAVA_THREADS_SOCKET_READ_HISTORY_1_5_15")) != null && attr.isLongArray()) {
                this.socketReadHistory = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("JAVA_THREADS_SOCKET_WRITTEN_HISTORY_1_5_15")) != null && attr.isLongArray()) {
                this.socketWriteHistory = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("MEMORY_AVAILABLE")) != null && attr.isLong()) {
                this.nativeMemAvailable = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("MEMORY_RESERVED")) != null && attr.isLong()) {
                this.nativeMemReserved = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("MEMORY_WORKINGSET")) != null && attr.isLong()) {
                this.workingSetSize = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("MAJOR_PAGE_FAULTS")) != null && attr.isLong()) {
                this.majorFaults = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("MAJOR_PAGE_FAULTS_HISTORY_1_5_15")) != null && attr.isLongArray()) {
                this.majorFaultsHistory = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("MINOR_PAGE_FAULTS")) != null && attr.isLong()) {
                this.minorFaults = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("MINOR_PAGE_FAULTS_HISTORY_1_5_15")) != null && attr.isLongArray()) {
                this.minorFaultsHistory = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("TOTAL_PAGE_FAULTS")) != null && attr.isLong()) {
                this.pageFaults = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("TOTAL_PAGE_FAULTS_HISTORY_1_5_15")) != null && attr.isLongArray()) {
                this.pageFaultsHistory = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("LOCK_CONTENTION")) != null && attr.isLong()) {
                this.lockContention = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("LOCK_CONTENTION_HISTORY_1_5_15")) != null && attr.isLongArray()) {
                this.lockContentionHistory = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("NUM_CLASSES_LOADED")) != null && attr.isInt()) {
                this.loadedClasses = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("NUM_CLASSES_UNLOADED")) != null && attr.isInt()) {
                this.unloadedClasses = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("NUM_ARRAYS_CREATED")) != null && attr.isInt()) {
                this.loadedArrayClasses = attr;
            }
            if ((attr = (MonitoringAttribute)attributes.get("NUM_ARRAYS_DESTROYED")) != null && attr.isInt()) {
                this.unloadedArrayClasses = attr;
            }
        }
    }

    private void handleBoard(long ts, long rawTs, byte[] buffer) {
        boolean getBoomark;
        boolean bl = getBoomark = this.nrOfBoards == 0;
        if (!getBoomark) {
            long bytesSinceLastBookmark = this.reader.getNrOfReadBytes() - this.lastNrOfReadBytesForBoardBookmark;
            long bytesSinceLastBoard = this.reader.getNrOfReadBytes() - this.lastNrOfReadBytesForBoard;
            if (bytesSinceLastBoard > 0x100000L && bytesSinceLastBookmark != bytesSinceLastBoard) {
                this.bookmarks.add(this.lastBoardBookmark);
                this.bookmarkTimes.resize(this.bookmarkTimes.size() + 1L);
                this.bookmarkTimes.set(this.bookmarkTimes.size() - 1L, this.lastTimeStampForBoard);
                this.bookmarkIndices.add(this.nrOfBoards - 1);
                this.lastNrOfReadBytesForBoardBookmark = this.lastNrOfReadBytesForBoard;
                bytesSinceLastBookmark = this.reader.getNrOfReadBytes() - this.lastNrOfReadBytesForBoardBookmark;
            }
            if (bytesSinceLastBookmark > 0x100000L) {
                getBoomark = true;
            }
        }
        this.lastBoardBookmark = this.reader.createBookmark();
        this.lastNrOfReadBytesForBoard = this.reader.getNrOfReadBytes();
        this.lastTimeStampForBoard = rawTs;
        if (getBoomark) {
            this.bookmarks.add(this.lastBoardBookmark);
            this.bookmarkTimes.resize(this.bookmarkTimes.size() + 1L);
            this.bookmarkTimes.set(this.bookmarkTimes.size() - 1L, rawTs);
            this.bookmarkIndices.add(this.nrOfBoards);
            this.lastNrOfReadBytesForBoardBookmark = this.reader.getNrOfReadBytes();
        }
        ++this.nrOfBoards;
        this.initAttributes(buffer);
        try {
            long diff;
            if (this.loadAvgAttr != null) {
                double[] loads = this.loadAvgAttr.getDoubleArray(buffer);
                this.builders[11].add(ts, (long)(loads[0] * 100000.0));
                this.builders[12].add(ts, (long)(loads[1] * 100000.0));
                this.builders[13].add(ts, (long)(loads[2] * 100000.0));
            }
            if (this.codeCacheOccupancyAttr != null && this.codeCacheMaxOccupancyAttr != null) {
                this.builders[15].add(ts, this.codeCacheOccupancyAttr.getLong(buffer));
                this.builders[14].add(ts, this.codeCacheMaxOccupancyAttr.getLong(buffer));
            }
            if (this.codeCacheTier1MethodsAttr != null && this.codeCacheTier2MethodsAttr != null) {
                long t1 = this.codeCacheTier1MethodsAttr.getInt(buffer);
                long t2 = this.codeCacheTier2MethodsAttr.getInt(buffer);
                this.builders[16].add(ts, t1);
                this.builders[17].add(ts, t2);
                this.builders[18].add(ts, t1 + t2);
            }
            if (this.threadStatesAttr != null) {
                int[] nrs = this.threadStatesAttr.getIntArray(buffer);
                this.builders[19].add(ts, nrs[0] + nrs[1] + nrs[2]);
                this.builders[20].add(ts, nrs[0]);
                this.builders[21].add(ts, nrs[1]);
                this.builders[22].add(ts, nrs[2]);
            }
            if (this.cumThreadsAttr != null) {
                this.builders[23].add(ts, this.cumThreadsAttr.getLong(buffer));
            }
            if (this.nrProcesses != null) {
                this.builders[24].add(ts, this.nrProcesses.getLong(buffer));
            }
            if (this.nrProcessesFailed != null) {
                this.builders[25].add(ts, this.nrProcessesFailed.getLong(buffer));
            }
            if (this.vmOperationCount != null) {
                this.builders[31].add(ts, this.vmOperationCount.getInt(buffer));
            }
            if (this.safepointCount != null) {
                this.builders[30].add(ts, this.safepointCount.getInt(buffer));
            }
            if (this.counterFreq != null) {
                long t;
                long f = this.counterFreq.getLong(buffer);
                if (this.vmOperationCount != null && this.cumVmOperationTime != null) {
                    int c = this.vmOperationCount.getInt(buffer);
                    t = this.cumVmOperationTime.getLong(buffer) * 1000000000L / ((long)c * f);
                    this.builders[32].add(ts, t);
                }
                if (this.safepointCount != null) {
                    int c = this.safepointCount.getInt(buffer);
                    if (this.cumSafepointTime != null) {
                        t = this.cumSafepointTime.getLong(buffer) * 1000000000L / ((long)c * f);
                        this.builders[27].add(ts, t);
                    }
                    if (this.cumSafepointSyncTime != null) {
                        t = this.cumSafepointSyncTime.getLong(buffer) * 1000000000L / ((long)c * f);
                        this.builders[28].add(ts, t);
                    }
                }
                if (this.maxSafepointTime != null) {
                    long t2 = this.maxSafepointTime.getLong(buffer) * 1000000000L / f;
                    this.builders[26].add(ts, t2);
                }
                if (this.maxSafepointSyncTime != null) {
                    long t3 = this.maxSafepointSyncTime.getLong(buffer) * 1000000000L / f;
                    this.builders[29].add(ts, t3);
                }
            }
            boolean do60minAvg = true;
            if (this.lastTs != 0L) {
                long diff2;
                if (this.openFiles != null) {
                    this.builders[33].add(ts, this.openFiles.getInt(buffer));
                }
                if (this.openSockets != null) {
                    this.builders[34].add(ts, this.openSockets.getInt(buffer));
                }
                long dt = ts - this.lastTs;
                if (this.fileRead != null) {
                    if (do60minAvg && this.fileReadHistory != null) {
                        diff2 = this.fileRead.getLong(buffer) - this.fileReadHistory.getLongArray(buffer)[0];
                        this.builders[35].add(ts, diff2 * 1000000L / (60L * dt));
                    } else {
                        diff2 = this.fileRead.getLong(buffer) - this.lastFileRead;
                        this.builders[35].add(ts, diff2 * 1000000L / dt);
                    }
                }
                if (this.fileWritten != null) {
                    if (do60minAvg && this.fileWriteHistory != null) {
                        diff2 = this.fileWritten.getLong(buffer) - this.fileWriteHistory.getLongArray(buffer)[0];
                        this.builders[36].add(ts, diff2 * 1000000L / (60L * dt));
                    } else {
                        diff2 = this.fileWritten.getLong(buffer) - this.lastFileWritten;
                        this.builders[36].add(ts, diff2 * 1000000L / dt);
                    }
                }
                if (this.socketRead != null) {
                    if (do60minAvg && this.socketReadHistory != null) {
                        diff2 = this.socketRead.getLong(buffer) - this.socketReadHistory.getLongArray(buffer)[0];
                        this.builders[37].add(ts, diff2 * 1000000L / (60L * dt));
                    } else {
                        diff2 = this.socketRead.getLong(buffer) - this.lastSocketRead;
                        this.builders[37].add(ts, diff2 * 1000000L / dt);
                    }
                }
                if (this.socketWritten != null) {
                    if (do60minAvg && this.socketWriteHistory != null) {
                        diff2 = this.socketWritten.getLong(buffer) - this.socketWriteHistory.getLongArray(buffer)[0];
                        this.builders[38].add(ts, diff2 * 1000000L / (60L * dt));
                    } else {
                        diff2 = this.socketWritten.getLong(buffer) - this.lastSocketWritten;
                        this.builders[38].add(ts, diff2 * 1000000L / dt);
                    }
                }
            }
            if (this.fileRead != null) {
                this.lastFileRead = this.fileRead.getLong(buffer);
            }
            if (this.fileWritten != null) {
                this.lastFileWritten = this.fileWritten.getLong(buffer);
            }
            if (this.socketRead != null) {
                this.lastSocketRead = this.socketRead.getLong(buffer);
            }
            if (this.socketWritten != null) {
                this.lastSocketWritten = this.socketWritten.getLong(buffer);
            }
            if (this.nativeMemAvailable != null) {
                this.builders[40].add(ts, this.nativeMemAvailable.getLong(buffer));
            }
            if (this.nativeMemReserved != null) {
                this.builders[39].add(ts, this.nativeMemReserved.getLong(buffer));
            }
            if (this.workingSetSize != null) {
                this.builders[41].add(ts, this.workingSetSize.getLong(buffer));
            }
            if (this.majorFaults != null && this.majorFaultsHistory != null) {
                diff = this.majorFaults.getLong(buffer) - this.majorFaultsHistory.getLongArray(buffer)[0];
                this.builders[43].add(ts, diff / 60L);
            } else if (this.pageFaults != null && this.pageFaultsHistory != null) {
                diff = this.pageFaults.getLong(buffer) - this.pageFaultsHistory.getLongArray(buffer)[0];
                this.builders[43].add(ts, diff / 60L);
            }
            if (this.minorFaults != null && this.minorFaultsHistory != null) {
                diff = this.minorFaults.getLong(buffer) - this.minorFaultsHistory.getLongArray(buffer)[0];
                this.builders[42].add(ts, diff / 60L);
            }
            if (this.lockContention != null && this.lockContentionHistory != null) {
                diff = this.lockContention.getLong(buffer) - this.lockContentionHistory.getLongArray(buffer)[0];
                this.builders[44].add(ts, diff / 60L);
            }
            if (this.loadedClasses != null) {
                this.builders[45].add(ts, this.loadedClasses.getInt(buffer));
            }
            if (this.unloadedClasses != null) {
                this.builders[46].add(ts, this.unloadedClasses.getInt(buffer));
            }
            if (this.loadedArrayClasses != null) {
                this.builders[47].add(ts, this.loadedArrayClasses.getInt(buffer));
            }
            if (this.unloadedArrayClasses != null) {
                this.builders[48].add(ts, this.unloadedArrayClasses.getInt(buffer));
            }
            this.lastTs = ts;
        }
        catch (IOException e) {
            Trace.debug((Throwable)e);
        }
    }

    public void handle(MonitoringBoardEvent event) {
        long ts = (event.getTimeStamp() - this.profilingStartupTimeStamp) * 1000L;
        this.handleBoard(ts, event.getTimeStamp(), event.getContent());
    }

    public void handle(MonitoringBoardDiffEvent event, byte[] board) {
        long ts = (event.getTimeStamp() - this.profilingStartupTimeStamp) * 1000L;
        this.handleBoard(ts, event.getTimeStamp(), board);
    }

    @Override
    public int getNrOfBoards() {
        return this.nrOfBoards;
    }

    @Override
    public byte[] getBoard(int boardIndex) {
        if (boardIndex < 0) {
            return null;
        }
        ResourceName name = this.getResourceName();
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        return new BoardRetriever(snapshot, boardIndex).getBoard();
    }

    @Override
    public long getBoardTimeStamp(int boardIndex) {
        if (boardIndex < 0) {
            return 0L;
        }
        ResourceName name = this.getResourceName();
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        return new BoardRetriever(snapshot, boardIndex).getTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntPair getIndicesOfRange(long fromTime, long toTime) {
        int i;
        int nrOfBookmarks = this.bookmarks.size();
        if (nrOfBookmarks == 0) {
            return new IntPair(-1, -1);
        }
        int startIndex = nrOfBookmarks - 1;
        int endIndex = nrOfBookmarks - 1;
        for (i = 0; i < nrOfBookmarks; ++i) {
            if (this.bookmarkTimes.get(i) <= fromTime) continue;
            startIndex = Math.max(0, i - 1);
            break;
        }
        if (this.bookmarkTimes.get(nrOfBookmarks - 1) < toTime) {
            endIndex = nrOfBookmarks - 1;
        } else {
            for (i = 0; i < nrOfBookmarks; ++i) {
                if (this.bookmarkTimes.get(i) <= toTime) continue;
                endIndex = Math.max(0, i - 1);
                break;
            }
        }
        Bookmark startBookmark = this.bookmarks.get(startIndex);
        Bookmark endBookmark = this.bookmarks.get(endIndex);
        int start = this.bookmarkIndices.get(startIndex);
        int end = this.bookmarkIndices.get(endIndex);
        IntPair result = new IntPair(-1, -1);
        ResourceName name = this.getResourceName();
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        ProgressReporter reporter = new ProgressReporter();
        ProfilingReader snapshotReader = null;
        try {
            MonitoringBoardEvent event;
            ProfilingPacket packet;
            if (this.bookmarkTimes.get(startIndex) < fromTime && (startIndex + 1 >= nrOfBookmarks || this.bookmarkIndices.get(startIndex) + 1 != this.bookmarkIndices.get(startIndex + 1) || this.bookmarkTimes.get(startIndex + 1) <= fromTime)) {
                snapshotReader = snapshot.getEventReader(reporter, startBookmark);
                while ((packet = snapshotReader.nextPacket()) != null) {
                    if (packet instanceof MonitoringBoardEvent) {
                        event = (MonitoringBoardEvent)packet;
                        if (event.getTimeStamp() >= fromTime) break;
                        ++start;
                        continue;
                    }
                    if (!(packet instanceof MonitoringBoardDiffEvent)) continue;
                    event = (MonitoringBoardDiffEvent)packet;
                    if (event.getTimeStamp() >= fromTime) break;
                    ++start;
                }
                snapshotReader.close();
                snapshotReader = null;
            }
            if (this.bookmarkTimes.get(endIndex) < toTime) {
                if (endIndex + 1 < nrOfBookmarks && this.bookmarkIndices.get(endIndex) + 1 == this.bookmarkIndices.get(endIndex + 1) && this.bookmarkTimes.get(endIndex + 1) > toTime) {
                    ++end;
                } else {
                    snapshotReader = snapshot.getEventReader(reporter, endBookmark);
                    while ((packet = snapshotReader.nextPacket()) != null) {
                        if (packet instanceof MonitoringBoardEvent) {
                            event = (MonitoringBoardEvent)packet;
                            if (event.getTimeStamp() > toTime) break;
                            ++end;
                            continue;
                        }
                        if (!(packet instanceof MonitoringBoardDiffEvent)) continue;
                        event = (MonitoringBoardDiffEvent)packet;
                        if (event.getTimeStamp() > toTime) break;
                        ++end;
                    }
                }
            }
            end = Math.max(start, end);
            result = new IntPair(start, end);
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, (String)"Error reading monitoring board");
        }
        finally {
            if (snapshotReader != null) {
                snapshotReader.close();
            }
            reporter.finish();
        }
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        super.write(writer, reporter);
        writer.writeVersion(1);
        writer.writeInt32(this.nrOfBoards);
        writer.writeInt32(this.bookmarks.size());
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            this.bookmarks.get(i).write(writer);
            writer.writeInt64(this.bookmarkTimes.get(i));
            writer.writeInt32(this.bookmarkIndices.get(i));
        }
    }

    private class BoardRetriever
    implements MonitoringEventHandler {
        private int index;
        private int currIndex;
        private byte[] currBoard;
        private long ts;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BoardRetriever(Snapshot snapshot, int boardIndex) {
            ProgressReporter reporter = new ProgressReporter();
            int nrOfBookmarks = (int)GeneralTimeSeriesImpl.this.bookmarkIndices.size();
            if (nrOfBookmarks > 0) {
                int bookmarkIndex = nrOfBookmarks - 1;
                for (int i = 1; i < nrOfBookmarks; ++i) {
                    if (boardIndex >= GeneralTimeSeriesImpl.this.bookmarkIndices.get(i)) continue;
                    bookmarkIndex = i - 1;
                    break;
                }
                Bookmark bookmark = (Bookmark)GeneralTimeSeriesImpl.this.bookmarks.get(bookmarkIndex);
                this.index = GeneralTimeSeriesImpl.this.bookmarkIndices.get(bookmarkIndex);
                this.currIndex = boardIndex;
                ProfilingReader snapshotReader = null;
                try {
                    snapshotReader = snapshot.getEventReader(reporter, bookmark);
                    snapshotReader.registerMonitoringEventHandler((MonitoringEventHandler)this);
                    while (snapshotReader.nextPacket() != null && this.index <= this.currIndex) {
                    }
                }
                catch (IOException e) {
                    Trace.warn((Throwable)e, (String)"Error reading packets");
                }
                finally {
                    if (snapshotReader != null) {
                        snapshotReader.close();
                    }
                    reporter.finish();
                }
            }
        }

        public byte[] getBoard() {
            return this.currBoard;
        }

        public long getTimeStamp() {
            return this.ts;
        }

        public void handle(EnableMonitoringBoardTraceResponse response) {
        }

        public void handle(DisableMonitoringBoardTraceResponse response) {
        }

        public void handle(MonitoringBoardEvent event) {
            if (this.currIndex == this.index) {
                this.currBoard = (byte[])event.getContent().clone();
                this.ts = event.getTimeStamp();
            }
            ++this.index;
        }

        public void handle(MonitoringBoardDiffEvent event, byte[] board) {
            if (this.currIndex == this.index) {
                this.currBoard = (byte[])board.clone();
                this.ts = event.getTimeStamp();
            }
            ++this.index;
        }
    }

    private static final class DebuggingSessionId {
        private final UTF8String clientId;
        private final short port;

        public DebuggingSessionId(UTF8String clientId, short port) {
            assert (clientId != null);
            this.clientId = clientId;
            this.port = port;
        }

        public int hashCode() {
            return this.clientId.hashCode() ^ this.port;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DebuggingSessionId)) {
                return false;
            }
            DebuggingSessionId other = (DebuggingSessionId)obj;
            return this.port == other.port && this.clientId.equals(other.clientId);
        }
    }

    private static class HeartBeatGCStatisticConverter
    implements DataConverter {
        private static final byte CONVERTER_VERSION = 0;

        private HeartBeatGCStatisticConverter() {
        }

        @Override
        public byte[] convert(Object obj) {
            if (obj == null) {
                return new byte[0];
            }
            HeartBeatGCStatistic statistic = (HeartBeatGCStatistic)obj;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeByte(0);
                dos.writeBoolean(statistic.isFullGc());
                dos.writeLong(statistic.getGcNr());
                dos.writeLong(statistic.getMemSizeBefore());
                dos.writeLong(statistic.getMemSizeAfter());
                dos.writeLong(statistic.getTimeMillis());
                dos.writeLong(statistic.getCpuTime());
                dos.writeLong(statistic.getDuration());
                dos.writeInt(GcCause.get((GcCause)statistic.getCause()));
                dos.close();
                return bos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public HeartBeatGCStatistic convert(byte[] data) {
            if (data.length == 0) {
                return null;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bis);
            try {
                byte version = dis.readByte();
                if (version < 0 || version > 0) {
                    throw new VersionMismatchException((int)version, 0, 0);
                }
                final boolean isFull = dis.readBoolean();
                final long gcNr = dis.readLong();
                final long memSizeBefore = dis.readLong();
                final long memSizeAfter = dis.readLong();
                final long timeMillis = dis.readLong();
                final long cpuTime = dis.readLong();
                final long duration = dis.readLong();
                final GcCause cause = GcCause.get((int)dis.readInt());
                HeartBeatGCStatistic result = new HeartBeatGCStatistic(){

                    public boolean isFullGc() {
                        return isFull;
                    }

                    public long getGcNr() {
                        return gcNr;
                    }

                    public long getMemSizeBefore() {
                        return memSizeBefore;
                    }

                    public long getMemSizeAfter() {
                        return memSizeAfter;
                    }

                    public long getTimeMillis() {
                        return timeMillis;
                    }

                    public long getCpuTime() {
                        return cpuTime;
                    }

                    public long getDuration() {
                        return duration;
                    }

                    public GcCause getCause() {
                        return cause;
                    }
                };
                return result;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

