/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.series;

import com.sap.jvm.profiling.snapshot.impl.util.series.DataConverter;
import com.sap.jvm.util.persistence.VersionMismatchException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class StringConverter
implements DataConverter {
    private static final byte VERSION = 0;

    @Override
    public Object convert(byte[] data) {
        if (data.length == 0) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bis);
        try {
            byte version = dis.readByte();
            if (version < 0 || version > 0) {
                throw new VersionMismatchException((int)version, 0, 0);
            }
            return dis.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] convert(Object obj) {
        if (obj == null) {
            return new byte[0];
        }
        String s = (String)obj;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeByte(0);
            dos.writeUTF(s);
            dos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

