/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.series;

import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.event.HeartBeatEvent;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.util.TimestampToBookmarkConverter;
import com.sap.jvm.profiling.util.splitarray.SplitArray64;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.pair.LongPair;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TimestampToBookmarkConverterImpl
extends AbstractResource
implements TimestampToBookmarkConverter {
    private static final int VERSION = 0;
    private final File filename = this.getFileName();
    private final long[] supportingPoints;
    private final int size;
    private final int supportingPointLog;
    private long lastPacketNr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TimestampToBookmarkConverterImpl(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name);
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        this.supportingPointLog = 12;
        Creator creator = new Creator(this.filename, 1 << this.supportingPointLog);
        try (ProfilingReader reader = snapshot.getEventReader(reporter);){
            ProfilingPacket packet;
            while ((packet = reader.nextPacket()) != null) {
                if (packet instanceof HeartBeatEvent) {
                    creator.add(((HeartBeatEvent)packet).getTimeMillis(), reader.createBookmark().getNrOfReadEvents());
                    continue;
                }
                if (!(packet instanceof GcStatistic)) continue;
                GcStatistic gc = (GcStatistic)packet;
                long timeStamp = gc.getTimestamp() + gc.getDuration() / 1000L;
                creator.add(timeStamp, reader.createBookmark().getNrOfReadEvents());
            }
        }
        this.supportingPoints = creator.getSupportingPoints();
        this.size = creator.getSize();
        this.lastPacketNr = reader.getNrOfReadPackets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimestampToBookmarkConverterImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(name);
        reader.readVersion(0);
        this.size = reader.readInt32();
        this.lastPacketNr = reader.readInt64();
        this.supportingPointLog = reader.readInt32();
        reporter.addWork(I18n._s((String)"Reading the time series"), reader.readInt64());
        this.supportingPoints = new long[reader.readInt32()];
        for (int i = 0; i < this.supportingPoints.length; ++i) {
            this.supportingPoints[i] = reader.readInt64();
        }
        byte[] buffer = new byte[8192];
        try (RandomAccessFile file = new RandomAccessFile(this.filename, "rw");){
            int toRead;
            for (long left = reader.readInt64(); left > 0L; left -= (long)toRead) {
                toRead = (int)Math.min((long)buffer.length, left);
                reporter.reportWorkOrThrow((long)toRead);
                reader.readBytes(buffer, 0, toRead);
                file.write(buffer, 0, toRead);
            }
        }
    }

    public static TimestampToBookmarkConverterImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        return new TimestampToBookmarkConverterImpl(name, reporter);
    }

    @Override
    public LongPair getBookmarks(long startTimestamp, long endTimestamp) {
        int pos;
        assert (startTimestamp <= endTimestamp);
        if (this.size == 0) {
            return new LongPair(0L, this.lastPacketNr);
        }
        for (pos = this.supportingPoints.length - 1; pos >= 0 && this.supportingPoints[pos] > startTimestamp; --pos) {
        }
        pos = Math.max(0, pos - 1);
        RandomAccessFile file = null;
        try {
            int index;
            file = new RandomAccessFile(this.filename, "r");
            file.seek(16L * (long)index);
            long start = 0L;
            for (index = pos * (1 << this.supportingPointLog); index < this.size; ++index) {
                long ts = file.readLong();
                long packetNr = file.readLong();
                if (ts > startTimestamp) break;
                start = packetNr;
                if (ts != startTimestamp) continue;
                break;
            }
            while (pos < this.supportingPoints.length && endTimestamp >= this.supportingPoints[pos]) {
                ++pos;
            }
            long end = -1L;
            pos = Math.max(0, pos - 1);
            file.seek(16L * (long)index);
            for (index = pos * (1 << this.supportingPointLog); index < this.size; ++index) {
                long ts = file.readLong();
                long packetNr = file.readLong();
                if (ts > endTimestamp) break;
                end = packetNr;
            }
            LongPair longPair = new LongPair(start, end);
            return longPair;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {
                    Trace.warn((Throwable)e, (String)"Could not close file");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        long left;
        writer.writeVersion(0);
        writer.writeInt32(this.size);
        writer.writeInt64(this.lastPacketNr);
        writer.writeInt32(this.supportingPointLog);
        writer.writeInt64(this.calculateWriteWork());
        writer.writeInt32(this.supportingPoints.length);
        for (int i = 0; i < this.supportingPoints.length; ++i) {
            writer.writeInt64(this.supportingPoints[i]);
        }
        assert (left == 16L * (long)this.size);
        writer.writeInt64(left);
        try (RandomAccessFile file = new RandomAccessFile(this.filename, "r");){
            int toRead;
            byte[] buffer = new byte[8192];
            for (left = this.filename.length(); left > 0L; left -= (long)toRead) {
                toRead = (int)Math.min((long)buffer.length, left);
                reporter.reportWorkOrThrow((long)toRead);
                file.readFully(buffer, 0, toRead);
                writer.writeBytes(buffer, 0, toRead);
            }
        }
    }

    @Override
    public long calculateWriteWork() {
        return (long)this.supportingPoints.length + this.filename.length();
    }

    private File getFileName() {
        ResourceManager manager = this.getResourceName().getResourceManager();
        String prefix = manager.getAddonPrefix(this.getResourceName());
        return new File(prefix + ".dat");
    }

    public boolean isModifiable() {
        return false;
    }

    public ResourceName[] getDependents() {
        return null;
    }

    private static class Creator {
        private int left;
        private DataOutputStream dos;
        private final SplitArray64 supportingPoints;
        private int size;
        private final int supportingPointDistance;

        public Creator(File filename, int supportingPointDistance) throws IOException {
            this.dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
            this.supportingPointDistance = supportingPointDistance;
            this.supportingPoints = new SplitArray64();
            this.left = 0;
        }

        public void add(long timeStamp, long packeteNr) throws IOException {
            this.dos.writeLong(timeStamp);
            this.dos.writeLong(packeteNr);
            if (this.left == 0) {
                this.supportingPoints.resize(this.supportingPoints.size() + 1L);
                this.supportingPoints.set(this.supportingPoints.size() - 1L, timeStamp);
                this.left = this.supportingPointDistance;
            }
            --this.left;
            ++this.size;
        }

        public int getSize() {
            return this.size;
        }

        public long[] getSupportingPoints() {
            long[] result = new long[(int)this.supportingPoints.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.supportingPoints.get(i);
            }
            try {
                this.dos.close();
            }
            catch (IOException e) {
                Trace.warn((Throwable)e, (String)"Could not close");
            }
            return result;
        }
    }
}

