/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.series;

import com.sap.jvm.profiling.resource.BasicResourceReader;
import com.sap.jvm.profiling.resource.BasicResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.snapshot.impl.util.series.DataConverter;
import com.sap.jvm.profiling.snapshot.impl.util.series.DataXYListBuilder;
import com.sap.jvm.profiling.snapshot.impl.util.series.FileCollection;
import com.sap.jvm.profiling.snapshot.impl.util.series.Uint16BasedXYList;
import com.sap.jvm.profiling.snapshot.impl.util.series.WritableTimeSeries;
import com.sap.jvm.profiling.util.dataset.XLongPredicate;
import com.sap.jvm.profiling.util.dataset.XYList;
import com.sap.jvm.profiling.util.dataset.XYListIterator;
import com.sap.jvm.profiling.util.splitarray.SplitArray32;
import com.sap.jvm.profiling.util.splitarray.SplitArray64;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class Uint16BasedDataXYList
implements WritableTimeSeries,
XYList {
    private static final int VERSION = 2;
    private final long minX;
    private final long maxX;
    private final long minY;
    private final long maxY;
    private final long lastY;
    private final int xLog;
    private final int yLog;
    private final int size;
    private final int nrOfSupportPoints;
    private FileCollection.Array<long[]> supportingPointsArray;
    private FileCollection.Array<int[]> supportingPointIndicesArray;
    private FileCollection.Array<int[]> supportingPointDataSizesArray;
    private FileCollection.Array<char[]> dataArray;
    private int fileIndex;
    private int dataFileIndex;
    private FileCollection fileCollection;
    private FileCollection dataFileCollection;
    private final DataConverter converter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uint16BasedDataXYList(DataOutputStream dos, DataOutputStream ddos, DataXYListBuilder builder, ProgressReporter reporter) throws IOException {
        this.minX = builder.getMinX();
        this.maxX = builder.getMaxX();
        this.minY = builder.getMinY();
        this.maxY = builder.getMaxY();
        this.lastY = builder.getLastY();
        this.xLog = Uint16BasedXYList.getLogForScale(builder.getMinimumXSeparation() / 131072L);
        this.yLog = Uint16BasedXYList.getLogForScale((this.maxY - this.minY) / 16384L);
        this.size = builder.getSize();
        this.converter = builder.getConverter();
        SplitArray64 sp = new SplitArray64();
        SplitArray32 spi = new SplitArray32();
        SplitArray32 spds = new SplitArray32();
        int nrOfPoints = 0;
        int lastPointNr = -1;
        DataInputStream dis = builder.getInputStream();
        DataInputStream ddis = builder.getDataInputStream();
        long xOff = 0L;
        int dataOffset = 0;
        int toSkip = 0;
        try {
            int i;
            long lastX = Long.MIN_VALUE;
            for (int i2 = 0; i2 < this.size; ++i2) {
                reporter.reportNextOrThrow();
                long x = dis.readLong();
                long y = dis.readLong();
                int emphasized = dis.readByte() != 0 ? 32768 : 0;
                int dataSize = ddis.readByte() & 0xFF;
                toSkip = 1 + dataSize;
                if (dataSize == 255) {
                    dataSize = ddis.readInt();
                    toSkip = 5 + dataSize;
                }
                byte[] data = new byte[dataSize];
                ddis.readFully(data);
                if (dataSize < 255) {
                    ddos.writeByte(dataSize);
                    ddos.write(data);
                } else {
                    ddos.writeByte(255);
                    ddos.writeInt(dataSize);
                    ddos.write(data);
                }
                assert (x >= this.minX && x <= this.maxX);
                int pointNr = (int)(x - this.minX >>> this.xLog + 16);
                if (pointNr > lastPointNr) {
                    lastPointNr = pointNr;
                    sp.resize(nrOfPoints + 1);
                    spi.resize(nrOfPoints + 1);
                    spds.resize(nrOfPoints + 1);
                    sp.set((long)nrOfPoints, x);
                    spi.set(nrOfPoints, i2);
                    spds.set(nrOfPoints, dataOffset);
                    dataOffset = 0;
                    xOff = x;
                    ++nrOfPoints;
                }
                int xCompressed = (int)(x - xOff >>> this.xLog);
                int yCompressed = (int)(y - this.minY >>> this.yLog);
                assert (xCompressed < 65536 && xCompressed >= 0);
                assert (yCompressed < 32768 && yCompressed >= 0);
                assert (lastX <= x);
                lastX = x;
                dataOffset += toSkip;
                dos.writeChar((char)xCompressed);
                dos.writeChar(emphasized | (char)yCompressed);
            }
            long[] tmp1 = new long[nrOfPoints + 1];
            for (int i3 = 0; i3 < nrOfPoints; ++i3) {
                tmp1[i3] = sp.get(i3);
            }
            tmp1[nrOfPoints] = 0x7FFFFFFFFFFFFFFEL;
            sp = null;
            int[] tmp2 = new int[nrOfPoints + 1];
            for (int i4 = 0; i4 < nrOfPoints; ++i4) {
                tmp2[i4] = spi.get(i4);
            }
            tmp2[nrOfPoints] = this.size;
            spi = null;
            int[] tmp3 = new int[nrOfPoints + 1];
            for (i = 0; i < nrOfPoints; ++i) {
                tmp3[i] = spds.get(i);
            }
            tmp3[nrOfPoints] = this.size;
            spds = null;
            for (i = 0; i <= nrOfPoints; ++i) {
                dos.writeLong(tmp1[i]);
            }
            for (i = 0; i <= nrOfPoints; ++i) {
                dos.writeInt(tmp2[i]);
            }
            for (i = 0; i <= nrOfPoints; ++i) {
                dos.writeInt(tmp3[i]);
            }
        }
        finally {
            dos.close();
            ddos.close();
        }
        this.nrOfSupportPoints = nrOfPoints + 1;
    }

    public Uint16BasedDataXYList(FileCollection fileCollection, FileCollection dataFileCollection, DataConverter converter, BasicResourceReader reader, ProgressReporter reporter) throws IOException {
        this.converter = converter;
        reader.readVersion(2);
        this.minX = reader.readInt64();
        this.maxX = reader.readInt64();
        this.minY = reader.readInt64();
        this.maxY = reader.readInt64();
        this.lastY = reader.readInt64();
        this.xLog = reader.readInt32();
        this.yLog = reader.readInt32();
        this.size = reader.readInt32();
        this.nrOfSupportPoints = reader.readInt32();
        this.fileIndex = reader.readInt32();
        this.dataFileIndex = reader.readInt32();
        this.assignFile(fileCollection, this.fileIndex, dataFileCollection, this.dataFileIndex);
    }

    @Override
    public void assignFile(FileCollection collection, int index, FileCollection dataCollection, int dataIndex) {
        this.fileIndex = index;
        this.fileCollection = collection;
        this.dataFileIndex = dataIndex;
        this.dataFileCollection = dataCollection;
    }

    public long getMinX() {
        return this.minX;
    }

    public long getMaxX() {
        return this.maxX;
    }

    public long getMinY() {
        return this.minY;
    }

    public long getMaxY() {
        return this.maxY;
    }

    public long getLastY() {
        return this.lastY;
    }

    public int getSize() {
        return this.size;
    }

    private synchronized long[] getSupportingPoints() {
        if (this.supportingPointsArray == null) {
            this.supportingPointsArray = this.fileCollection.getLongArray(this.fileIndex, this.size * 4, this.nrOfSupportPoints);
        }
        return this.supportingPointsArray.getContent();
    }

    private synchronized int[] getSupportingPointIndices() {
        if (this.supportingPointIndicesArray == null) {
            this.supportingPointIndicesArray = this.fileCollection.getIntArray(this.fileIndex, this.size * 4 + this.nrOfSupportPoints * 8, this.nrOfSupportPoints);
        }
        return this.supportingPointIndicesArray.getContent();
    }

    private synchronized int[] getSupportingPointDataSizes() {
        if (this.supportingPointDataSizesArray == null) {
            this.supportingPointDataSizesArray = this.fileCollection.getIntArray(this.fileIndex, this.size * 4 + this.nrOfSupportPoints * 12, this.nrOfSupportPoints);
        }
        return this.supportingPointDataSizesArray.getContent();
    }

    private synchronized char[] getData() {
        if (this.dataArray == null) {
            this.dataArray = this.fileCollection.getCharArray(this.fileIndex, 0, this.size * 2);
        }
        return this.dataArray.getContent();
    }

    public int getIndexOfX(long x) {
        if (x < this.minX) {
            return 0;
        }
        if (x > this.maxX) {
            return this.size - 1;
        }
        int pos = Arrays.binarySearch(this.getSupportingPoints(), x);
        if (pos >= 0) {
            return this.getSupportingPointIndices()[pos];
        }
        assert (pos < -1);
        pos = -pos - 2;
        int index = this.getSupportingPointIndices()[pos];
        assert (this.getX(index) < x);
        XYListIterator it = this.getIterator(index, this.size - 1);
        while (it.next()) {
            if (it.x >= x) {
                assert (index > 0);
                it.close();
                return it.x == x ? index : index - 1;
            }
            ++index;
        }
        it.close();
        return this.size - 1;
    }

    public long getX(int index) {
        int supportingPointIndex = Arrays.binarySearch(this.getSupportingPointIndices(), index);
        if (supportingPointIndex < 0) {
            supportingPointIndex = Math.max(0, -supportingPointIndex - 2);
        }
        char raw = this.getData()[index * 2];
        return this.getSupportingPoints()[supportingPointIndex] + ((long)raw << this.xLog);
    }

    public long getY(int index) {
        char raw = (char)(this.getData()[1 + index * 2] & Short.MAX_VALUE);
        return this.minY + ((long)raw << this.yLog);
    }

    public boolean isEmphasized(int index) {
        char raw = (char)(this.getData()[1 + index * 2] & 0x8000);
        return raw != '\u0000';
    }

    public int getLowest(int start, XLongPredicate predicate) {
        int result;
        for (result = start; result >= 0 && predicate.applies(this.getX(result)); --result) {
        }
        return result + 1;
    }

    public int getHighest(int start, XLongPredicate predicate) {
        int result;
        for (result = start; result < this.size && predicate.applies(this.getX(result)); ++result) {
        }
        return result - 1;
    }

    public XYListIterator getIterator(int firstIndex, int lastIndex) {
        try {
            return new ListIterator(firstIndex, lastIndex);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(BasicResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(2);
        writer.writeInt64(this.minX);
        writer.writeInt64(this.maxX);
        writer.writeInt64(this.minY);
        writer.writeInt64(this.maxY);
        writer.writeInt64(this.lastY);
        writer.writeInt32(this.xLog);
        writer.writeInt32(this.yLog);
        writer.writeInt32(this.size);
        writer.writeInt32(this.nrOfSupportPoints);
        writer.writeInt32(this.fileIndex);
        writer.writeInt32(this.dataFileIndex);
    }

    public Object getData(long x, long y) {
        int index;
        int pos = Arrays.binarySearch(this.getSupportingPoints(), x);
        if (pos < 0) {
            pos = Math.max(0, -pos - 2);
        }
        int startIndex = index = this.getSupportingPointIndices()[pos];
        XYListIterator it = this.getIterator(index, this.size - 1);
        while (it.next()) {
            if (x <= it.x) {
                it.close();
                break;
            }
            ++index;
        }
        long offset = 0L;
        for (int i = 0; i <= pos; ++i) {
            offset += (long)this.getSupportingPointDataSizes()[i];
        }
        DataInputStream dis = null;
        try {
            dis = this.dataFileCollection.getInputStream(this.dataFileIndex, 0);
            int step = 1000000;
            while (offset > (long)step) {
                dis.skipBytes(step);
                offset -= (long)step;
            }
            dis.skipBytes((int)offset);
            for (int i = startIndex; i < index; ++i) {
                int toSkip2 = dis.readByte() & 0xFF;
                if (toSkip2 == 255) {
                    toSkip2 = dis.readInt();
                }
                dis.skipBytes(toSkip2);
            }
            int toSkip = dis.readByte() & 0xFF;
            if (toSkip == 255) {
                toSkip = dis.readInt();
            }
            if (toSkip == 0) {
                Object toSkip2 = null;
                return toSkip2;
            }
            byte[] result = new byte[toSkip];
            dis.readFully(result);
            Object object = this.converter.convert(result);
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    class ListIterator
    extends XYListIterator {
        private int index;
        private int lastIndex;
        private long[] supportingPoints;
        private int[] supportingPointIndices;
        private char[] data;
        private int supportingPointIndex;
        private int nextSupportingPointIndex;
        private long xOff;

        public ListIterator(int firstIndex, int lastIndex) throws IOException {
            this.index = firstIndex;
            this.lastIndex = lastIndex;
            if (this.index <= lastIndex) {
                this.supportingPoints = Uint16BasedDataXYList.this.getSupportingPoints();
                this.supportingPointIndices = Uint16BasedDataXYList.this.getSupportingPointIndices();
                this.data = Uint16BasedDataXYList.this.getData();
                int spi = Arrays.binarySearch(this.supportingPointIndices, this.index);
                this.supportingPointIndex = spi < 0 ? Math.max(0, -spi - 2) : spi;
                this.nextSupportingPointIndex = this.supportingPointIndices[this.supportingPointIndex + 1];
                this.xOff = this.supportingPoints[this.supportingPointIndex];
            }
        }

        public boolean next() {
            if (this.index > this.lastIndex) {
                return false;
            }
            if (this.index == this.nextSupportingPointIndex) {
                ++this.supportingPointIndex;
                this.nextSupportingPointIndex = this.supportingPointIndices[this.supportingPointIndex + 1];
                this.xOff = this.supportingPoints[this.supportingPointIndex];
            }
            this.x = this.xOff + ((long)this.data[this.index * 2] << Uint16BasedDataXYList.this.xLog);
            char raw = this.data[this.index * 2 + 1];
            this.y = Uint16BasedDataXYList.this.minY + ((long)(raw & Short.MAX_VALUE) << Uint16BasedDataXYList.this.yLog);
            this.emphasized = (raw & 0x8000) != 0;
            ++this.index;
            return true;
        }

        public void close() {
            this.supportingPoints = null;
            this.supportingPointIndices = null;
            this.data = null;
        }
    }
}

