/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.series;

import com.sap.jvm.profiling.resource.BasicResourceReader;
import com.sap.jvm.profiling.resource.BasicResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.snapshot.impl.util.series.FileCollection;
import com.sap.jvm.profiling.snapshot.impl.util.series.WritableTimeSeries;
import com.sap.jvm.profiling.snapshot.impl.util.series.XYListBuilder;
import com.sap.jvm.profiling.util.dataset.XLongPredicate;
import com.sap.jvm.profiling.util.dataset.XYList;
import com.sap.jvm.profiling.util.dataset.XYListIterator;
import com.sap.jvm.profiling.util.splitarray.SplitArray32;
import com.sap.jvm.profiling.util.splitarray.SplitArray64;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class Uint16BasedXYList
implements WritableTimeSeries,
XYList {
    private static final int VERSION = 2;
    private final long minX;
    private final long maxX;
    private final long minY;
    private final long maxY;
    private final long lastY;
    private final int xLog;
    private final int yLog;
    private final int size;
    private final int nrOfSupportPoints;
    private FileCollection.Array<long[]> supportingPointsArray;
    private FileCollection.Array<int[]> supportingPointIndicesArray;
    private FileCollection.Array<char[]> dataArray;
    private int fileIndex;
    private FileCollection fileCollection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uint16BasedXYList(DataOutputStream dos, XYListBuilder builder, ProgressReporter reporter) throws IOException {
        this.minX = builder.getMinX();
        this.maxX = builder.getMaxX();
        this.minY = builder.getMinY();
        this.maxY = builder.getMaxY();
        this.lastY = builder.getLastY();
        this.xLog = Uint16BasedXYList.getLogForScale(builder.getMinimumXSeparation() / 131072L);
        this.yLog = Uint16BasedXYList.getLogForScale((this.maxY - this.minY) / 32768L);
        this.size = builder.getSize();
        SplitArray64 sp = new SplitArray64();
        SplitArray32 spi = new SplitArray32();
        int nrOfPoints = 0;
        int lastPointNr = -1;
        DataInputStream dis = builder.getInputStream();
        long xOff = 0L;
        long x = 0L;
        long y = 0L;
        try {
            int i;
            long prevX = Long.MIN_VALUE;
            for (int i2 = 0; i2 < this.size; ++i2) {
                reporter.reportNextOrThrow();
                x = dis.readLong();
                y = dis.readLong();
                assert (x >= this.minX && x <= this.maxX);
                int pointNr = (int)(x - this.minX >>> this.xLog + 16);
                if (pointNr > lastPointNr) {
                    lastPointNr = pointNr;
                    sp.resize(nrOfPoints + 1);
                    spi.resize(nrOfPoints + 1);
                    sp.set((long)nrOfPoints, x);
                    spi.set(nrOfPoints, i2);
                    xOff = x;
                    ++nrOfPoints;
                }
                int xCompressed = (int)(x - xOff >>> this.xLog);
                int yCompressed = (int)(y - this.minY >>> this.yLog);
                assert (xCompressed < 65536 && xCompressed >= 0);
                assert (yCompressed < 65536 && yCompressed >= 0);
                assert (prevX <= x);
                prevX = x;
                dos.writeChar((char)xCompressed);
                dos.writeChar((char)yCompressed);
            }
            long[] tmp1 = new long[nrOfPoints + 1];
            for (int i3 = 0; i3 < nrOfPoints; ++i3) {
                tmp1[i3] = sp.get(i3);
            }
            tmp1[nrOfPoints] = 0x7FFFFFFFFFFFFFFEL;
            sp = null;
            int[] tmp2 = new int[nrOfPoints + 1];
            for (i = 0; i < nrOfPoints; ++i) {
                tmp2[i] = spi.get(i);
            }
            tmp2[nrOfPoints] = this.size;
            spi = null;
            for (i = 0; i <= nrOfPoints; ++i) {
                dos.writeLong(tmp1[i]);
            }
            for (i = 0; i <= nrOfPoints; ++i) {
                dos.writeInt(tmp2[i]);
            }
        }
        finally {
            dos.close();
        }
        this.nrOfSupportPoints = nrOfPoints + 1;
    }

    public Uint16BasedXYList(FileCollection fileCollection, BasicResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(2);
        this.minX = reader.readInt64();
        this.maxX = reader.readInt64();
        this.minY = reader.readInt64();
        this.maxY = reader.readInt64();
        this.lastY = reader.readInt64();
        this.xLog = reader.readInt32();
        this.yLog = reader.readInt32();
        this.size = reader.readInt32();
        this.nrOfSupportPoints = reader.readInt32();
        this.fileIndex = reader.readInt32();
        this.assignFile(fileCollection, this.fileIndex, null, 0);
    }

    @Override
    public void assignFile(FileCollection collection, int index, FileCollection dataCollection, int dataIndex) {
        this.fileIndex = index;
        this.fileCollection = collection;
    }

    public long getMinX() {
        return this.minX;
    }

    public long getMaxX() {
        return this.maxX;
    }

    public long getMinY() {
        return this.minY;
    }

    public long getMaxY() {
        return this.maxY;
    }

    public long getLastY() {
        return this.lastY;
    }

    public int getSize() {
        return this.size;
    }

    private synchronized long[] getSupportingPoints() {
        if (this.supportingPointsArray == null) {
            this.supportingPointsArray = this.fileCollection.getLongArray(this.fileIndex, this.size * 4, this.nrOfSupportPoints);
        }
        return this.supportingPointsArray.getContent();
    }

    private synchronized int[] getSupportingPointIndices() {
        if (this.supportingPointIndicesArray == null) {
            this.supportingPointIndicesArray = this.fileCollection.getIntArray(this.fileIndex, this.size * 4 + this.nrOfSupportPoints * 8, this.nrOfSupportPoints);
        }
        return this.supportingPointIndicesArray.getContent();
    }

    private synchronized char[] getData() {
        if (this.dataArray == null) {
            this.dataArray = this.fileCollection.getCharArray(this.fileIndex, 0, this.size * 2);
        }
        return this.dataArray.getContent();
    }

    public int getIndexOfX(long x) {
        if (x < this.minX) {
            return 0;
        }
        if (x > this.maxX) {
            return this.size - 1;
        }
        int pos = Arrays.binarySearch(this.getSupportingPoints(), x);
        if (pos >= 0) {
            return this.getSupportingPointIndices()[pos];
        }
        assert (pos < -1);
        pos = -pos - 2;
        int index = this.getSupportingPointIndices()[pos];
        assert (this.getX(index) < x);
        XYListIterator it = this.getIterator(index, this.size - 1);
        while (it.next()) {
            if (it.x >= x) {
                assert (index > 0);
                it.close();
                return it.x == x ? index : index - 1;
            }
            ++index;
        }
        it.close();
        return this.size - 1;
    }

    public long getX(int index) {
        int supportingPointIndex = Arrays.binarySearch(this.getSupportingPointIndices(), index);
        if (supportingPointIndex < 0) {
            supportingPointIndex = Math.max(0, -supportingPointIndex - 2);
        }
        char raw = this.getData()[index * 2];
        return this.getSupportingPoints()[supportingPointIndex] + ((long)raw << this.xLog);
    }

    public long getY(int index) {
        char raw = this.getData()[1 + index * 2];
        return this.minY + ((long)raw << this.yLog);
    }

    public boolean isEmphasized(int index) {
        return false;
    }

    public int getLowest(int start, XLongPredicate predicate) {
        int result;
        for (result = start; result >= 0 && predicate.applies(this.getX(result)); --result) {
        }
        return result + 1;
    }

    public int getHighest(int start, XLongPredicate predicate) {
        int result;
        for (result = start; result < this.size && predicate.applies(this.getX(result)); ++result) {
        }
        return result - 1;
    }

    public XYListIterator getIterator(int firstIndex, int lastIndex) {
        try {
            return new ListIterator(firstIndex, lastIndex);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getData(long x, long y) {
        return null;
    }

    @Override
    public void write(BasicResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(2);
        writer.writeInt64(this.minX);
        writer.writeInt64(this.maxX);
        writer.writeInt64(this.minY);
        writer.writeInt64(this.maxY);
        writer.writeInt64(this.lastY);
        writer.writeInt32(this.xLog);
        writer.writeInt32(this.yLog);
        writer.writeInt32(this.size);
        writer.writeInt32(this.nrOfSupportPoints);
        writer.writeInt32(this.fileIndex);
    }

    static int getLogForScale(long scale) {
        int result = 0;
        while (1L << result < scale) {
            ++result;
        }
        return result;
    }

    class ListIterator
    extends XYListIterator {
        private int index;
        private int lastIndex;
        private int supportingPointIndex;
        private int nextSupportingPointIndex;
        private long xOff;
        private long[] supportingPoints;
        private int[] supportingPointIndices;
        private char[] data;

        public ListIterator(int firstIndex, int lastIndex) throws IOException {
            this.index = firstIndex;
            this.lastIndex = lastIndex;
            if (this.index <= lastIndex) {
                this.supportingPoints = Uint16BasedXYList.this.getSupportingPoints();
                this.supportingPointIndices = Uint16BasedXYList.this.getSupportingPointIndices();
                this.data = Uint16BasedXYList.this.getData();
                int spi = Arrays.binarySearch(this.supportingPointIndices, this.index);
                this.supportingPointIndex = spi < 0 ? Math.max(0, -spi - 2) : spi;
                this.nextSupportingPointIndex = this.supportingPointIndices[this.supportingPointIndex + 1];
                this.xOff = this.supportingPoints[this.supportingPointIndex];
            }
        }

        public boolean next() {
            if (this.index > this.lastIndex) {
                return false;
            }
            if (this.index == this.nextSupportingPointIndex) {
                ++this.supportingPointIndex;
                this.nextSupportingPointIndex = this.supportingPointIndices[this.supportingPointIndex + 1];
                this.xOff = this.supportingPoints[this.supportingPointIndex];
            }
            this.x = this.xOff + ((long)this.data[this.index * 2] << Uint16BasedXYList.this.xLog);
            this.y = Uint16BasedXYList.this.minY + ((long)this.data[this.index * 2 + 1] << Uint16BasedXYList.this.yLog);
            ++this.index;
            return true;
        }

        public void close() {
            this.supportingPoints = null;
            this.supportingPointIndices = null;
            this.data = null;
        }
    }
}

