/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.series;

import com.sap.jvm.profiling.snapshot.impl.util.series.DataConverter;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class XEventListBuilder {
    private final File filename;
    private long minX = Long.MAX_VALUE;
    private long maxX = Long.MIN_VALUE;
    private int size;
    private DataOutputStream dos;
    private DataConverter converter;

    public XEventListBuilder(File filename, DataConverter converter) throws IOException {
        this.filename = new File(filename + ".gz");
        this.converter = converter;
        this.dos = new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream((OutputStream)new FileOutputStream(this.filename), new Deflater(1, false))));
    }

    public void add(long x) throws IOException {
        this.dos.writeLong(x);
        this.dos.writeLong(0L);
        this.dos.writeByte(0);
        ++this.size;
        this.minX = Math.min(this.minX, x);
        this.maxX = Math.max(this.maxX, x);
    }

    public void add(long x, Object data) throws IOException {
        assert (data == null || this.converter != null);
        this.dos.writeLong(x);
        this.dos.writeLong(0L);
        if (data == null) {
            this.dos.write(0);
        } else {
            byte[] bytes = this.converter.convert(data);
            if (bytes.length < 255) {
                this.dos.write((byte)bytes.length);
            } else {
                this.dos.writeByte(-1);
                this.dos.writeInt(bytes.length);
            }
            this.dos.write(bytes);
        }
        ++this.size;
        this.minX = Math.min(this.minX, x);
        this.maxX = Math.max(this.maxX, x);
    }

    public void add(long x, long range) throws IOException {
        this.dos.writeLong(x);
        this.dos.writeLong(range);
        this.dos.writeByte(0);
        ++this.size;
        this.minX = Math.min(this.minX, x);
        this.maxX = Math.max(this.maxX, x + range);
    }

    public void add(long x, long range, Object data) throws IOException {
        assert (data == null || this.converter != null);
        this.dos.writeLong(x);
        this.dos.writeLong(range);
        if (data == null) {
            this.dos.write(0);
        } else {
            byte[] bytes = this.converter.convert(data);
            if (bytes.length < 255) {
                this.dos.write((byte)bytes.length);
            } else {
                this.dos.writeByte(-1);
                this.dos.writeInt(bytes.length);
            }
            this.dos.write(bytes);
        }
        ++this.size;
        this.minX = Math.min(this.minX, x);
        this.maxX = Math.max(this.maxX, x + range);
    }

    public long getMinX() {
        return this.minX;
    }

    public long getMaxX() {
        return this.maxX;
    }

    public int getSize() {
        return this.size;
    }

    public File getFilename() throws IOException {
        if (this.dos != null) {
            this.dos.close();
            this.dos = null;
        }
        return this.filename;
    }

    public DataConverter getConverter() {
        return this.converter;
    }
}

