/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.series;

import com.sap.jvm.profiling.resource.BasicResourceReader;
import com.sap.jvm.profiling.resource.BasicResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.snapshot.impl.util.series.DataConverter;
import com.sap.jvm.profiling.snapshot.impl.util.series.FileCollection;
import com.sap.jvm.profiling.snapshot.impl.util.series.WritableTimeSeries;
import com.sap.jvm.profiling.snapshot.impl.util.series.XEventListBuilder;
import com.sap.jvm.profiling.util.dataset.XEventList;
import com.sap.jvm.profiling.util.dataset.XEventListIterator;
import com.sap.jvm.util.persistence.FileHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class XEventListImpl
implements WritableTimeSeries,
XEventList {
    private static final int VERSION = 1;
    private final long minX;
    private final long maxX;
    private final int size;
    private final DataConverter converter;
    private int fileIndex;
    private FileCollection fileCollection;

    public XEventListImpl(DataOutputStream dos, XEventListBuilder builder) throws IOException {
        this.minX = builder.getMinX();
        this.maxX = builder.getMaxX();
        this.size = builder.getSize();
        this.converter = builder.getConverter();
        InflaterInputStream is = new InflaterInputStream(new FileInputStream(builder.getFilename()), new Inflater(false));
        FileHelper.copy((InputStream)is, (OutputStream)dos);
        ((InputStream)is).close();
        dos.close();
        builder.getFilename().delete();
    }

    public XEventListImpl(FileCollection fileCollection, DataConverter converter, BasicResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.minX = reader.readInt64();
        this.maxX = reader.readInt64();
        this.size = reader.readInt32();
        this.fileIndex = reader.readInt32();
        this.fileCollection = fileCollection;
        this.converter = converter;
    }

    @Override
    public void assignFile(FileCollection collection, int index, FileCollection dataCollection, int dataIndex) {
        this.fileIndex = index;
        this.fileCollection = collection;
    }

    public long getMinX() {
        return this.minX;
    }

    public long getMaxX() {
        return this.maxX;
    }

    public int getSize() {
        return this.size;
    }

    public XEventListIterator getIterator() {
        try {
            return new Iterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(BasicResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        writer.writeInt64(this.minX);
        writer.writeInt64(this.maxX);
        writer.writeInt32(this.size);
        writer.writeInt32(this.fileIndex);
    }

    private class Iterator
    extends XEventListIterator {
        private DataInputStream dis;
        private int left;

        public Iterator() throws IOException {
            this.dis = XEventListImpl.this.fileCollection.getInputStream(XEventListImpl.this.fileIndex, 0);
            this.left = XEventListImpl.this.size;
        }

        public boolean next() {
            if (this.left == 0) {
                return false;
            }
            --this.left;
            try {
                this.x = this.dis.readLong();
                this.range = this.dis.readLong();
                int dataLen = this.dis.readByte() & 0xFF;
                if (XEventListImpl.this.converter != null) {
                    if (dataLen == 255) {
                        dataLen = this.dis.readInt();
                    }
                    byte[] tmp = new byte[dataLen];
                    int off = 0;
                    while (dataLen > 0) {
                        int read = this.dis.read(tmp, off, dataLen);
                        if (read <= 0) {
                            throw new RuntimeException("Could not read the data");
                        }
                        off += read;
                        dataLen -= read;
                    }
                    this.data = XEventListImpl.this.converter.convert(tmp);
                } else {
                    assert (dataLen == 0);
                    this.data = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        public void close() {
            if (this.dis != null) {
                try {
                    this.dis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.dis = null;
            }
        }
    }
}

