/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.series;

import com.sap.jvm.tracing.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class XYListBuilder {
    private final File filename;
    protected DataOutputStream dos;
    private DataInputStream dis;
    private long lastX = Long.MIN_VALUE;
    private long minX = Long.MIN_VALUE;
    private long maxX = Long.MAX_VALUE;
    private long minY = Long.MAX_VALUE;
    private long maxY = Long.MIN_VALUE;
    private long lastY;
    private long minXSep = Long.MAX_VALUE;
    private int size;

    public XYListBuilder(File filename) throws IOException {
        this.filename = filename;
        this.dos = new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream((OutputStream)new FileOutputStream(filename + ".gz"), new Deflater(1, false))));
    }

    public boolean add(long x, long y) throws IOException {
        this.lastY = y;
        if (this.size == 0) {
            this.minX = x;
            this.maxX = x;
            this.minY = y;
            this.maxY = y;
        } else {
            this.minX = Math.min(this.minX, x);
            this.maxX = Math.max(this.maxX, x);
            this.minY = Math.min(this.minY, y);
            this.maxY = Math.max(this.maxY, y);
            long sep = x - this.lastX;
            if (sep < 0L) {
                return false;
            }
            if (sep > 0L) {
                this.minXSep = Math.min(this.minXSep, sep);
            }
        }
        this.dos.writeLong(x);
        this.dos.writeLong(y);
        ++this.size;
        this.lastX = x;
        return true;
    }

    public File getFilename() {
        return this.filename;
    }

    public DataInputStream getInputStream() throws IOException {
        this.dos.close();
        this.dos = null;
        this.dis = new DataInputStream(new BufferedInputStream(new InflaterInputStream(new FileInputStream(this.filename + ".gz"), new Inflater(false))));
        return this.dis;
    }

    public void close() {
        try {
            if (this.dos != null) {
                this.dos.close();
            }
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, (String)"Could not close");
        }
        try {
            if (this.dis != null) {
                this.dis.close();
            }
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, (String)"Could not close");
        }
        new File(this.filename + ".gz").delete();
    }

    public long getMinX() {
        return this.minX;
    }

    public long getMaxX() {
        return this.maxX;
    }

    public long getMinY() {
        return this.minY;
    }

    public long getMaxY() {
        return this.maxY;
    }

    public long getLastY() {
        return this.lastY;
    }

    public int getSize() {
        return this.size;
    }

    public long getMinimumXSeparation() {
        return this.minXSep;
    }
}

