/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.io;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public final class IOOperations
implements Value<IOOperations> {
    public static final IOOperations EMPTY = new IOOperations(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    private static final int VERSION = 0;
    private final long openCount;
    private final long closeCount;
    private final long readBytes;
    private final long writtenBytes;
    private final long readTime;
    private final long writeTime;
    private final long readOperations;
    private final long writeOperations;

    public IOOperations(long openCount, long closeCount, long readBytes, long writtenBytes, long readTime, long writeTime, long readOperations, long writeOperations) {
        this.openCount = openCount;
        this.closeCount = closeCount;
        this.readBytes = readBytes;
        this.writtenBytes = writtenBytes;
        if (readTime < 0L) {
            this.readTime = 0L;
            Trace.warn(() -> "Found negative read duration: readTime=" + readTime);
        } else {
            this.readTime = readTime;
        }
        if (writeTime < 0L) {
            this.writeTime = 0L;
            Trace.warn(() -> "Found negative write duration: writeTime=" + writeTime);
        } else {
            this.writeTime = writeTime;
        }
        this.readOperations = readOperations;
        this.writeOperations = writeOperations;
    }

    public IOOperations(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.openCount = reader.readInt64();
        this.closeCount = reader.readInt64();
        this.readBytes = reader.readInt64();
        this.writtenBytes = reader.readInt64();
        this.readTime = reader.readInt64();
        this.writeTime = reader.readInt64();
        this.readOperations = reader.readInt64();
        this.writeOperations = reader.readInt64();
    }

    public long getOpenCount() {
        return this.openCount;
    }

    public long getCloseCount() {
        return this.closeCount;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public long getReadOperations() {
        return this.readOperations;
    }

    public long getWriteOperations() {
        return this.writeOperations;
    }

    @Override
    public IOOperations getSum(IOOperations toAdd) {
        assert (this.writeTime >= 0L);
        assert (toAdd.writeTime >= 0L);
        assert (this.writeTime + toAdd.writeTime >= 0L);
        return new IOOperations(this.openCount + toAdd.openCount, this.closeCount + toAdd.closeCount, this.readBytes + toAdd.readBytes, this.writtenBytes + toAdd.writtenBytes, this.readTime + toAdd.readTime, this.writeTime + toAdd.writeTime, this.readOperations + toAdd.readOperations, this.writeOperations + toAdd.writeOperations);
    }

    public IOOperations getSum(long openCountToAdd, long closeCountToAdd, long readBytesToAdd, long writtenBytesToAdd, long readTimeToAdd, long writeTimeToAdd, long readOperationsToAdd, long writeOperationsToAdd) {
        return new IOOperations(this.openCount + openCountToAdd, this.closeCount + closeCountToAdd, this.readBytes + readBytesToAdd, this.writtenBytes + writtenBytesToAdd, this.readTime + readTimeToAdd, this.writeTime + writeTimeToAdd, this.readOperations + readOperationsToAdd, this.writeOperations + writeOperationsToAdd);
    }

    public String toString() {
        return this.openCount + " open events, " + this.closeCount + " close events, " + this.readBytes + " read bytes, " + this.writtenBytes + " written bytes, " + this.readTime + " read time, " + this.writeTime + " write time, " + this.readOperations + " read operations, " + this.writeOperations + " write operations";
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt64(this.openCount);
        writer.writeInt64(this.closeCount);
        writer.writeInt64(this.readBytes);
        writer.writeInt64(this.writtenBytes);
        writer.writeInt64(this.readTime);
        writer.writeInt64(this.writeTime);
        writer.writeInt64(this.readOperations);
        writer.writeInt64(this.writeOperations);
    }
}

