/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.io;

import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public final class IOOperationsAndDetails
implements Value<IOOperationsAndDetails> {
    public static final IOOperationsAndDetails EMPTY = new IOOperationsAndDetails(0L, 0L, 0L, null, 0L, 0L, null, 0L, 0L, 0L, 0L, 0L, 0L);
    private static final int VERSION = 0;
    private static final UTF8String MISSING = UTF8Creator.create((String)"");
    private final long fd;
    private final long openTimestamp;
    private final long closeTimestamp;
    private final long openingThreadId;
    private final UTF8String openingThreadName;
    private final long closingThreadId;
    private final UTF8String closingThreadName;
    private final long readBytes;
    private final long writtenBytes;
    private final long readTime;
    private final long writeTime;
    private final long readOperations;
    private final long writeOperations;

    public IOOperationsAndDetails(long fd, long openTimestamp, long openingThreadId, UTF8String openingThreadName, long closeTimestamp, long closingThreadId, UTF8String closingThreadName, long readBytes, long writtenBytes, long readTime, long writeTime, long readOperations, long writeOperations) {
        this.fd = fd;
        this.openTimestamp = openTimestamp;
        this.openingThreadId = openingThreadId;
        this.openingThreadName = openingThreadName;
        this.closeTimestamp = closeTimestamp;
        this.closingThreadId = closingThreadId;
        this.closingThreadName = closingThreadName;
        this.readBytes = readBytes;
        this.writtenBytes = writtenBytes;
        if (readTime < 0L) {
            this.readTime = 0L;
            Trace.warn(() -> "Found negative read duration: readTime=" + readTime);
        } else {
            this.readTime = readTime;
        }
        if (writeTime < 0L) {
            this.writeTime = 0L;
            Trace.warn(() -> "Found negative write duration: writeTime=" + writeTime);
        } else {
            this.writeTime = writeTime;
        }
        this.readOperations = readOperations;
        this.writeOperations = writeOperations;
    }

    public IOOperationsAndDetails(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.fd = reader.readInt64();
        this.openTimestamp = reader.readInt64();
        this.openingThreadId = reader.readInt64();
        this.openingThreadName = reader.readBoolean() ? reader.readUTF() : null;
        this.closeTimestamp = reader.readInt64();
        this.closingThreadId = reader.readInt64();
        this.closingThreadName = reader.readBoolean() ? reader.readUTF() : null;
        this.readBytes = reader.readInt64();
        this.writtenBytes = reader.readInt64();
        this.readTime = reader.readInt64();
        this.writeTime = reader.readInt64();
        this.readOperations = reader.readInt64();
        this.writeOperations = reader.readInt64();
    }

    public long getFd() {
        return this.fd;
    }

    public long getOpeningThreadId() {
        return this.openingThreadId;
    }

    public UTF8String getOpeningThreadName() {
        return this.openingThreadName == null ? MISSING : this.openingThreadName;
    }

    public long getOpenTimestamp() {
        return this.openTimestamp;
    }

    public long getClosingThreadId() {
        return this.closingThreadId;
    }

    public UTF8String getClosingThreadName() {
        return this.closingThreadName == null ? MISSING : this.closingThreadName;
    }

    public long getCloseTimestamp() {
        return this.closeTimestamp;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public long getReadOperations() {
        return this.readOperations;
    }

    public long getWriteOperations() {
        return this.writeOperations;
    }

    @Override
    public IOOperationsAndDetails getSum(IOOperationsAndDetails toAdd) {
        long newFd = this.fd;
        if (toAdd.fd != 0L) {
            newFd = toAdd.fd;
        }
        long newOpeningThreadId = this.openingThreadId;
        if (toAdd.openingThreadId > 0L) {
            newOpeningThreadId = toAdd.openingThreadId;
        }
        long newClosingThreadId = this.closingThreadId;
        if (toAdd.closingThreadId > 0L) {
            newClosingThreadId = toAdd.closingThreadId;
        }
        long newOpenTimestamp = this.openTimestamp;
        if (toAdd.openTimestamp > 0L) {
            newOpenTimestamp = toAdd.openTimestamp;
        }
        long newCloseTimestamp = this.closeTimestamp;
        if (toAdd.closeTimestamp > 0L) {
            newCloseTimestamp = toAdd.closeTimestamp;
        }
        UTF8String newOpeningThreadName = this.openingThreadName;
        if (toAdd.openingThreadName != null) {
            newOpeningThreadName = toAdd.openingThreadName;
        }
        UTF8String newClosingThreadName = this.closingThreadName;
        if (toAdd.closingThreadName != null) {
            newClosingThreadName = toAdd.closingThreadName;
        }
        return new IOOperationsAndDetails(newFd, newOpenTimestamp, newOpeningThreadId, newOpeningThreadName, newCloseTimestamp, newClosingThreadId, newClosingThreadName, this.readBytes + toAdd.readBytes, this.writtenBytes + toAdd.writtenBytes, this.readTime + toAdd.readTime, this.writeTime + toAdd.writeTime, this.readOperations + toAdd.readOperations, this.writeOperations + toAdd.writeOperations);
    }

    public String toString() {
        return "fd=" + this.fd + ", opened by " + this.openingThreadName + " [" + this.openingThreadId + "] at " + this.openTimestamp + ", closed by " + this.closingThreadName + " [" + this.closingThreadId + "] at " + this.closeTimestamp + ", " + this.readBytes + " read bytes, " + this.writtenBytes + " written bytes, " + this.readTime + " read time, " + this.writeTime + " write time, " + this.readOperations + " read operations, " + this.writeOperations + " write operations";
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt64(this.fd);
        writer.writeInt64(this.openTimestamp);
        writer.writeInt64(this.openingThreadId);
        writer.writeBoolean(this.openingThreadName != null);
        if (this.openingThreadName != null) {
            writer.writeUTF(this.openingThreadName);
        }
        writer.writeInt64(this.closeTimestamp);
        writer.writeInt64(this.closingThreadId);
        writer.writeBoolean(this.closingThreadName != null);
        if (this.closingThreadName != null) {
            writer.writeUTF(this.closingThreadName);
        }
        writer.writeInt64(this.readBytes);
        writer.writeInt64(this.writtenBytes);
        writer.writeInt64(this.readTime);
        writer.writeInt64(this.writeTime);
        writer.writeInt64(this.readOperations);
        writer.writeInt64(this.writeOperations);
    }
}

