/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.mpt;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;

public abstract class CpuAndElapsedTime
implements Value<CpuAndElapsedTime> {
    public static final CpuAndElapsedTime EMPTY = CpuAndElapsedTime.create(0L, 0L);
    private static final int VERSION = 0;

    public static CpuAndElapsedTime create(long cpuTime, long elapsedTime) {
        assert (cpuTime >= 0L);
        assert (elapsedTime >= 0L);
        if ((cpuTime | elapsedTime) >>> 32 == 0L) {
            return new SmallCpuAndElapsedTime(cpuTime, elapsedTime);
        }
        return new BigCpuAndElapsedTime(cpuTime, elapsedTime);
    }

    public static CpuAndElapsedTime read(ResourceReader reader) throws IOException {
        reader.readVersion(0);
        return CpuAndElapsedTime.create(reader.readInt64(), reader.readInt64());
    }

    public abstract long getElapsedTime();

    public abstract long getCpuTime();

    public final void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt64(this.getElapsedTime());
        writer.writeInt64(this.getCpuTime());
    }

    @Override
    public CpuAndElapsedTime getSum(CpuAndElapsedTime toAdd) {
        return CpuAndElapsedTime.create(this.getCpuTime() + toAdd.getCpuTime(), this.getElapsedTime() + toAdd.getElapsedTime());
    }

    public CpuAndElapsedTime getSum(long cpuTimeToAdd, long elapsedTimeToAdd) {
        return CpuAndElapsedTime.create(this.getCpuTime() + cpuTimeToAdd, this.getElapsedTime() + elapsedTimeToAdd);
    }

    private static final class BigCpuAndElapsedTime
    extends CpuAndElapsedTime {
        private final long cpuTime;
        private final long elapsedTime;

        public BigCpuAndElapsedTime(long cpuTime, long elapsedTime) {
            this.cpuTime = cpuTime;
            this.elapsedTime = elapsedTime;
        }

        @Override
        public long getCpuTime() {
            return this.cpuTime;
        }

        @Override
        public long getElapsedTime() {
            return this.elapsedTime;
        }
    }

    private static final class SmallCpuAndElapsedTime
    extends CpuAndElapsedTime {
        private final int cpuTime;
        private final int elapsedTime;

        public SmallCpuAndElapsedTime(long cpuTime, long elapsedTime) {
            this.cpuTime = (int)(cpuTime + Integer.MIN_VALUE);
            this.elapsedTime = (int)(elapsedTime + Integer.MIN_VALUE);
            assert (cpuTime == this.getCpuTime());
            assert (elapsedTime == this.getElapsedTime());
        }

        @Override
        public long getCpuTime() {
            return (long)this.cpuTime - Integer.MIN_VALUE;
        }

        @Override
        public long getElapsedTime() {
            return (long)this.elapsedTime - Integer.MIN_VALUE;
        }
    }
}

