/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.mpt;

import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.resource.InvocationDist;
import com.sap.jvm.profiling.snapshot.resource.SimpleInvocationDist;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;

public class InvocationsAndTime
implements Value<InvocationsAndTime> {
    public static final InvocationsAndTime EMPTY = new InvocationsAndTime(SimpleInvocationDist.EMPTY, 0L, 0L);
    public static final InvocationsAndTime INTERPRETED = new InvocationsAndTime(SimpleInvocationDist.INTERPRETED, 0L, 0L);
    public static final InvocationsAndTime INTERPRETED_NATIVE = new InvocationsAndTime(SimpleInvocationDist.INTERPRETED_NATIVE, 0L, 0L);
    public static final InvocationsAndTime COMPILED = new InvocationsAndTime(SimpleInvocationDist.COMPILED, 0L, 0L);
    public static final InvocationsAndTime COMPILED_NATIVE = new InvocationsAndTime(SimpleInvocationDist.COMPILED_NATIVE, 0L, 0L);
    public static final InvocationsAndTime COMPILED_TIER_1 = new InvocationsAndTime(SimpleInvocationDist.COMPILED_TIER_1, 0L, 0L);
    public static final InvocationsAndTime COMPILED_NATIVE_TIER_1 = new InvocationsAndTime(SimpleInvocationDist.COMPILED_NATIVE_TIER_1, 0L, 0L);
    public static final InvocationsAndTime INLINED = new InvocationsAndTime(SimpleInvocationDist.INLINED, 0L, 0L);
    public static final InvocationsAndTime INLINED_NATIVE = new InvocationsAndTime(SimpleInvocationDist.INLINED_NATIVE, 0L, 0L);
    public static final InvocationsAndTime INLINED_TIER_1 = new InvocationsAndTime(SimpleInvocationDist.INLINED_TIER_1, 0L, 0L);
    public static final InvocationsAndTime INLINED_NATIVE_TIER_1 = new InvocationsAndTime(SimpleInvocationDist.INLINED_NATIVE_TIER_1, 0L, 0L);
    public static final InvocationsAndTime OTHER = new InvocationsAndTime(SimpleInvocationDist.OTHER, 0L, 0L);
    private static final int VERSION = 0;
    private final InvocationDist invocations;
    private final long cpuTime;
    private final long elapsedTime;

    public InvocationsAndTime(InvocationDist invocations, long cpuTime, long elapsedTime) {
        this.invocations = invocations;
        this.cpuTime = cpuTime;
        this.elapsedTime = elapsedTime;
    }

    public InvocationsAndTime(ResourceReader reader) throws IOException {
        reader.readVersion(0);
        this.invocations = new SimpleInvocationDist(reader);
        this.cpuTime = reader.readInt64();
        this.elapsedTime = reader.readInt64();
    }

    public InvocationDist getInvocations() {
        return this.invocations;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public long getCpuTime() {
        return this.cpuTime;
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        this.invocations.write(writer);
        writer.writeInt64(this.cpuTime);
        writer.writeInt64(this.elapsedTime);
    }

    @Override
    public InvocationsAndTime getSum(InvocationsAndTime toAdd) {
        return new InvocationsAndTime(this.invocations.getSum(toAdd.invocations), this.cpuTime + toAdd.cpuTime, this.elapsedTime + toAdd.elapsedTime);
    }

    public InvocationsAndTime getSum(InvocationDist invocationsToAdd, long timeToAdd, long cpuTimeToAdd) {
        return new InvocationsAndTime(this.invocations.getSum(invocationsToAdd), this.cpuTime + cpuTimeToAdd, this.elapsedTime + timeToAdd);
    }

    public static InvocationsAndTime getDist(MethodParameterEntryEvent entry) {
        if (entry.isCompiled()) {
            return COMPILED;
        }
        if (entry.isInterpreted()) {
            return INTERPRETED;
        }
        if (entry.isCompiledTier1()) {
            return COMPILED_TIER_1;
        }
        if (entry.isCompiledNative()) {
            return COMPILED_NATIVE;
        }
        if (entry.isCompiledNativeTier1()) {
            return COMPILED_NATIVE_TIER_1;
        }
        if (entry.isInterpretedNative()) {
            return INTERPRETED_NATIVE;
        }
        if (entry.isOther()) {
            return OTHER;
        }
        if (entry.isInlined()) {
            return INLINED;
        }
        if (entry.isInlinedTier1()) {
            return INLINED_TIER_1;
        }
        if (entry.isInlinedNative()) {
            return INLINED_NATIVE;
        }
        assert (entry.isInlinedNativeTier1());
        return INLINED_NATIVE_TIER_1;
    }
}

