/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.net;

import com.sap.jvm.profiling.core.type.IpAddress;

public final class NetworkConnection {
    private final IpAddress localAddress;
    private final char localPort;
    private final IpAddress remoteAddress;
    private final char remotePort;
    private final boolean isStreamSocket;

    public NetworkConnection(IpAddress localAddress, char localPort, IpAddress remoteAddress, char remotePort, boolean isStreamSocket) {
        this.localAddress = localAddress;
        this.localPort = localPort;
        this.remoteAddress = remoteAddress;
        this.remotePort = remotePort;
        this.isStreamSocket = isStreamSocket;
    }

    public IpAddress getLocalAddress() {
        return this.localAddress;
    }

    public char getLocalPort() {
        return this.localPort;
    }

    public IpAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public char getRemotePort() {
        return this.remotePort;
    }

    public boolean isStreamSocket() {
        return this.isStreamSocket;
    }

    public boolean isDatagramSocket() {
        return !this.isStreamSocket();
    }

    public String toString() {
        return "local address=" + this.localAddress + ":" + this.localPort + ", remote address=" + this.remoteAddress + ":" + this.remotePort + (this.isStreamSocket ? " [TCP]" : " [UDP]");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localAddress == null ? 0 : this.localAddress.hashCode());
        result = 31 * result + this.localPort;
        result = 31 * result + (this.remoteAddress == null ? 0 : this.remoteAddress.hashCode());
        result = 31 * result + this.remotePort;
        result = 31 * result + (this.isStreamSocket ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof NetworkConnection)) {
            return false;
        }
        NetworkConnection other = (NetworkConnection)obj;
        if (this.localAddress == null ? other.localAddress != null : !this.localAddress.equals(other.localAddress)) {
            return false;
        }
        if (this.localPort != other.localPort) {
            return false;
        }
        if (this.remoteAddress == null ? other.remoteAddress != null : !this.remoteAddress.equals(other.remoteAddress)) {
            return false;
        }
        if (this.remotePort != other.remotePort) {
            return false;
        }
        return this.isStreamSocket == other.isStreamSocket;
    }
}

