/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.net;

import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.snapshot.util.Value;

public final class NetworkDetails
implements Value<NetworkDetails> {
    public static final NetworkDetails EMPTY = new NetworkDetails(0L, 0L, 0L, null, 0L, 0L, null);
    private static final UTF8String MISSING = UTF8Creator.create((String)"");
    private final long fd;
    private final long openTimestamp;
    private final long closeTimestamp;
    private final long openingThreadId;
    private final UTF8String openingThreadName;
    private final long closingThreadId;
    private final UTF8String closingThreadName;

    public NetworkDetails(long fd, long openTimestamp, long openingThreadId, UTF8String openingThreadName, long closeTimestamp, long closingThreadId, UTF8String closingThreadName) {
        this.fd = fd;
        this.openTimestamp = openTimestamp;
        this.openingThreadId = openingThreadId;
        this.openingThreadName = openingThreadName;
        this.closeTimestamp = closeTimestamp;
        this.closingThreadId = closingThreadId;
        this.closingThreadName = closingThreadName;
    }

    public long getFd() {
        return this.fd;
    }

    public long getOpeningThreadId() {
        return this.openingThreadId;
    }

    public UTF8String getOpeningThreadName() {
        return this.openingThreadName == null ? MISSING : this.openingThreadName;
    }

    public long getOpenTimestamp() {
        return this.openTimestamp;
    }

    public long getClosingThreadId() {
        return this.closingThreadId;
    }

    public UTF8String getClosingThreadName() {
        return this.closingThreadName == null ? MISSING : this.closingThreadName;
    }

    public long getCloseTimestamp() {
        return this.closeTimestamp;
    }

    @Override
    public NetworkDetails getSum(NetworkDetails toAdd) {
        long newFd = this.fd;
        if (toAdd.fd != 0L) {
            newFd = toAdd.fd;
        }
        long newOpeningThreadId = this.openingThreadId;
        if (toAdd.openingThreadId > 0L) {
            newOpeningThreadId = toAdd.openingThreadId;
        }
        long newClosingThreadId = this.closingThreadId;
        if (toAdd.closingThreadId > 0L) {
            newClosingThreadId = toAdd.closingThreadId;
        }
        long newOpenTimestamp = this.openTimestamp;
        if (toAdd.openTimestamp > 0L) {
            newOpenTimestamp = toAdd.openTimestamp;
        }
        long newCloseTimestamp = this.closeTimestamp;
        if (toAdd.closeTimestamp > 0L) {
            newCloseTimestamp = toAdd.closeTimestamp;
        }
        UTF8String newOpeningThreadName = this.openingThreadName;
        if (toAdd.openingThreadName != null) {
            newOpeningThreadName = toAdd.openingThreadName;
        }
        UTF8String newClosingThreadName = this.closingThreadName;
        if (toAdd.closingThreadName != null) {
            newClosingThreadName = toAdd.closingThreadName;
        }
        return new NetworkDetails(newFd, newOpenTimestamp, newOpeningThreadId, newOpeningThreadName, newCloseTimestamp, newClosingThreadId, newClosingThreadName);
    }

    public String toString() {
        return "fd=" + this.fd + ", opened by " + this.openingThreadName + " [" + this.openingThreadId + "] at " + this.openTimestamp + ", closed by " + this.closingThreadName + " [" + this.closingThreadId + "] at " + this.closeTimestamp;
    }
}

