/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.net;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;

public final class NetworkLatencies
implements Value<NetworkLatencies> {
    public static final NetworkLatencies EMPTY = new NetworkLatencies(Long.MAX_VALUE, Long.MIN_VALUE, 0L, 0L, Long.MAX_VALUE, Long.MIN_VALUE, 0L, 0L, true);
    private static final int VERSION = 0;
    private final long minReadWriteLatency;
    private final long maxReadWriteLatency;
    private final long readWriteLatencySum;
    private final long readWriteLatencyCount;
    private final long minWriteReadLatency;
    private final long maxWriteReadLatency;
    private final long writeReadLatencySum;
    private final long writeReadLatencyCount;
    private final long minDefaultLatency;
    private final long maxDefaultLatency;
    private final long defaultLatencySum;
    private final long defaultLatencyCount;

    public NetworkLatencies(long minReadWriteLatency, long maxReadWriteLatency, long readWriteLatencySum, long readWriteLatencyCount, long minWriteReadLatency, long maxWriteReadLatency, long writeReadLatencySum, long writeReadLatencyCount, boolean isServer) {
        this(minReadWriteLatency, maxReadWriteLatency, readWriteLatencySum, readWriteLatencyCount, minWriteReadLatency, maxWriteReadLatency, writeReadLatencySum, writeReadLatencyCount, isServer ? minReadWriteLatency : minWriteReadLatency, isServer ? maxReadWriteLatency : maxWriteReadLatency, isServer ? readWriteLatencySum : writeReadLatencySum, isServer ? readWriteLatencyCount : writeReadLatencyCount);
    }

    public NetworkLatencies(long minReadWriteLatency, long maxReadWriteLatency, long readWriteLatencySum, long readWriteLatencyCount, long minWriteReadLatency, long maxWriteReadLatency, long writeReadLatencySum, long writeReadLatencyCount, long minDefaultLatency, long maxDefaultLatency, long defaultLatencySum, long defaultLatencyCount) {
        this.minReadWriteLatency = minReadWriteLatency;
        this.maxReadWriteLatency = maxReadWriteLatency;
        this.readWriteLatencySum = readWriteLatencySum;
        this.readWriteLatencyCount = readWriteLatencyCount;
        this.minWriteReadLatency = minWriteReadLatency;
        this.maxWriteReadLatency = maxWriteReadLatency;
        this.writeReadLatencySum = writeReadLatencySum;
        this.writeReadLatencyCount = writeReadLatencyCount;
        this.minDefaultLatency = minDefaultLatency;
        this.maxDefaultLatency = maxDefaultLatency;
        this.defaultLatencySum = defaultLatencySum;
        this.defaultLatencyCount = defaultLatencyCount;
    }

    public NetworkLatencies(ResourceReader reader) throws IOException {
        this(reader, true, 0);
    }

    NetworkLatencies(ResourceReader reader, boolean readVersion, int version) throws IOException {
        if (readVersion) {
            reader.readVersion(version, version);
        }
        this.minReadWriteLatency = reader.readInt64();
        this.maxReadWriteLatency = reader.readInt64();
        this.readWriteLatencySum = reader.readInt64();
        this.readWriteLatencyCount = reader.readInt64();
        this.minWriteReadLatency = reader.readInt64();
        this.maxWriteReadLatency = reader.readInt64();
        this.writeReadLatencySum = reader.readInt64();
        this.writeReadLatencyCount = reader.readInt64();
        this.minDefaultLatency = reader.readInt64();
        this.maxDefaultLatency = reader.readInt64();
        this.defaultLatencySum = reader.readInt64();
        this.defaultLatencyCount = reader.readInt64();
    }

    public long getMinReadWriteLatency() {
        return this.minReadWriteLatency == Long.MAX_VALUE ? 0L : this.minReadWriteLatency;
    }

    public long getMaxReadWriteLatency() {
        return this.maxReadWriteLatency == Long.MIN_VALUE ? 0L : this.maxReadWriteLatency;
    }

    public long getReadWriteLatencySum() {
        return this.readWriteLatencySum;
    }

    public long getReadWriteLatencyCount() {
        return this.readWriteLatencyCount;
    }

    public long getMinWriteReadLatency() {
        return this.minWriteReadLatency == Long.MAX_VALUE ? 0L : this.minWriteReadLatency;
    }

    public long getMaxWriteReadLatency() {
        return this.maxWriteReadLatency == Long.MIN_VALUE ? 0L : this.maxWriteReadLatency;
    }

    public long getWriteReadLatencySum() {
        return this.writeReadLatencySum;
    }

    public long getWriteReadLatencyCount() {
        return this.writeReadLatencyCount;
    }

    public long getMinDefaultLatency() {
        return this.minDefaultLatency == Long.MAX_VALUE ? 0L : this.minDefaultLatency;
    }

    public long getMaxDefaultLatency() {
        return this.maxDefaultLatency == Long.MIN_VALUE ? 0L : this.maxDefaultLatency;
    }

    public long getDefaultLatencySum() {
        return this.defaultLatencySum;
    }

    public long getDefaultLatencyCount() {
        return this.defaultLatencyCount;
    }

    @Override
    public NetworkLatencies getSum(NetworkLatencies toAdd) {
        return new NetworkLatencies(Math.min(this.minReadWriteLatency, toAdd.minReadWriteLatency), Math.max(this.maxReadWriteLatency, toAdd.maxReadWriteLatency), this.readWriteLatencySum + toAdd.readWriteLatencySum, this.readWriteLatencyCount + toAdd.readWriteLatencyCount, Math.min(this.minWriteReadLatency, toAdd.minWriteReadLatency), Math.max(this.maxWriteReadLatency, toAdd.maxWriteReadLatency), this.writeReadLatencySum + toAdd.writeReadLatencySum, this.writeReadLatencyCount + toAdd.writeReadLatencyCount, Math.min(this.minDefaultLatency, toAdd.minDefaultLatency), Math.max(this.maxDefaultLatency, toAdd.maxDefaultLatency), this.defaultLatencySum + toAdd.defaultLatencySum, this.defaultLatencyCount + toAdd.defaultLatencyCount);
    }

    public NetworkLatencies getSum(long minReadWriteLatencyToAdd, long maxReadWriteLatencyToAdd, long readWriteLatencySumToAdd, long readWriteLatencyCountToAdd, long minWriteReadLatencyToAdd, long maxWriteReadLatencyToAdd, long writeReadLatencySumToAdd, long writeReadLatencyCountToAdd, long minDefaultLatencyToAdd, long maxDefaultLatencyToAdd, long defaultLatencySumToAdd, long defaultLatencyCountToAdd) {
        return new NetworkLatencies(Math.min(this.minReadWriteLatency, minReadWriteLatencyToAdd), Math.max(this.maxReadWriteLatency, maxReadWriteLatencyToAdd), this.readWriteLatencySum + readWriteLatencySumToAdd, this.readWriteLatencyCount + readWriteLatencyCountToAdd, Math.min(this.minWriteReadLatency, minWriteReadLatencyToAdd), Math.max(this.maxWriteReadLatency, maxWriteReadLatencyToAdd), this.writeReadLatencySum + writeReadLatencySumToAdd, this.writeReadLatencyCount + writeReadLatencyCountToAdd, Math.min(this.minDefaultLatency, minDefaultLatencyToAdd), Math.max(this.maxDefaultLatency, maxDefaultLatencyToAdd), this.defaultLatencySum + defaultLatencySumToAdd, this.defaultLatencyCount + defaultLatencyCountToAdd);
    }

    public String toString() {
        return this.minDefaultLatency + " min default latency, " + this.maxDefaultLatency + " max default latency, " + this.defaultLatencySum + " default latency sum, " + this.defaultLatencyCount + " default transitions, " + this.minReadWriteLatency + " min r/w latency, " + this.maxReadWriteLatency + " max r/w latency, " + this.readWriteLatencySum + " r/w latency sum, " + this.readWriteLatencyCount + " r/w transitions, " + this.minWriteReadLatency + " min w/r latency, " + this.maxWriteReadLatency + " max w/r latency, " + this.writeReadLatencySum + " w/r latency sum, " + this.writeReadLatencyCount + " w/r transitions";
    }

    public void write(ResourceWriter writer) throws IOException {
        this.write(writer, true, 0);
    }

    void write(ResourceWriter writer, boolean writeVersion, int version) throws IOException {
        if (writeVersion) {
            writer.writeVersion(version);
        }
        writer.writeInt64(this.minReadWriteLatency);
        writer.writeInt64(this.maxReadWriteLatency);
        writer.writeInt64(this.readWriteLatencySum);
        writer.writeInt64(this.readWriteLatencyCount);
        writer.writeInt64(this.minWriteReadLatency);
        writer.writeInt64(this.maxWriteReadLatency);
        writer.writeInt64(this.writeReadLatencySum);
        writer.writeInt64(this.writeReadLatencyCount);
        writer.writeInt64(this.minDefaultLatency);
        writer.writeInt64(this.maxDefaultLatency);
        writer.writeInt64(this.defaultLatencySum);
        writer.writeInt64(this.defaultLatencyCount);
    }
}

