/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.net;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.net.NetworkLatencies;
import com.sap.jvm.profiling.snapshot.net.NetworkOperations;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;

public final class NetworkOperationsAndLatencies
implements Value<NetworkOperationsAndLatencies> {
    public static final NetworkOperationsAndLatencies EMPTY = new NetworkOperationsAndLatencies(NetworkOperations.EMPTY, NetworkLatencies.EMPTY);
    private static final int VERSION = 0;
    private final NetworkOperations operations;
    private final NetworkLatencies latencies;

    public NetworkOperationsAndLatencies(long openCount, long closeCount, long readBytes, long writtenBytes, long readTime, long writeTime, long readOperations, long writeOperations, long minReadWriteLatency, long maxReadWriteLatency, long readWriteLatencySum, long readWriteLatencyCount, long minWriteReadLatency, long maxWriteReadLatency, long writeReadLatencySum, long writeReadLatencyCount, long minDefaultLatency, long maxDefaultLatency, long defaultLatencySum, long defaultLatencyCount) {
        this.operations = new NetworkOperations(openCount, closeCount, readBytes, writtenBytes, readTime, writeTime, readOperations, writeOperations);
        this.latencies = new NetworkLatencies(minReadWriteLatency, maxReadWriteLatency, readWriteLatencySum, readWriteLatencyCount, minWriteReadLatency, maxWriteReadLatency, writeReadLatencySum, writeReadLatencyCount, minDefaultLatency, maxDefaultLatency, defaultLatencySum, defaultLatencyCount);
    }

    public NetworkOperationsAndLatencies(NetworkOperations operations, NetworkLatencies latencies) {
        this.operations = operations;
        this.latencies = latencies;
    }

    public NetworkOperationsAndLatencies(ResourceReader reader) throws IOException {
        this.operations = new NetworkOperations(reader, true, 0);
        this.latencies = new NetworkLatencies(reader, false, 0);
    }

    public long getOpenCount() {
        return this.operations.getOpenCount();
    }

    public long getCloseCount() {
        return this.operations.getCloseCount();
    }

    public long getReadBytes() {
        return this.operations.getReadBytes();
    }

    public long getWrittenBytes() {
        return this.operations.getWrittenBytes();
    }

    public long getReadTime() {
        return this.operations.getReadTime();
    }

    public long getWriteTime() {
        return this.operations.getWriteTime();
    }

    public long getReadOperations() {
        return this.operations.getReadOperations();
    }

    public long getWriteOperations() {
        return this.operations.getWriteOperations();
    }

    public long getMinReadWriteLatency() {
        return this.latencies.getMinReadWriteLatency();
    }

    public long getMaxReadWriteLatency() {
        return this.latencies.getMaxReadWriteLatency();
    }

    public long getReadWriteLatencySum() {
        return this.latencies.getReadWriteLatencySum();
    }

    public long getReadWriteLatencyCount() {
        return this.latencies.getReadWriteLatencyCount();
    }

    public long getMinWriteReadLatency() {
        return this.latencies.getMinWriteReadLatency();
    }

    public long getMaxWriteReadLatency() {
        return this.latencies.getMaxWriteReadLatency();
    }

    public long getWriteReadLatencySum() {
        return this.latencies.getWriteReadLatencySum();
    }

    public long getWriteReadLatencyCount() {
        return this.latencies.getWriteReadLatencyCount();
    }

    public long getMinDefaultLatency() {
        return this.latencies.getMinDefaultLatency();
    }

    public long getMaxDefaultLatency() {
        return this.latencies.getMaxDefaultLatency();
    }

    public long getDefaultLatencySum() {
        return this.latencies.getDefaultLatencySum();
    }

    public long getDefaultLatencyCount() {
        return this.latencies.getDefaultLatencyCount();
    }

    @Override
    public NetworkOperationsAndLatencies getSum(NetworkOperationsAndLatencies toAdd) {
        return new NetworkOperationsAndLatencies(this.operations.getSum(toAdd.operations), this.latencies.getSum(toAdd.latencies));
    }

    public String toString() {
        return this.operations.toString() + ", " + this.latencies.toString();
    }

    public void write(ResourceWriter writer) throws IOException {
        this.operations.write(writer, true, 0);
        this.latencies.write(writer, false, 0);
    }
}

