/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.net;

import com.sap.jvm.profiling.snapshot.net.NetworkConnectionSideType;

public final class NetworkService {
    private final String serviceName;
    private final char port;
    private final NetworkConnectionSideType side;
    private final boolean isStream;

    public NetworkService(String serviceName, char port, NetworkConnectionSideType side, boolean isStream) {
        this.serviceName = serviceName;
        this.port = port;
        this.side = side;
        this.isStream = isStream;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public char getPort() {
        return this.port;
    }

    public NetworkConnectionSideType getSideType() {
        return this.side;
    }

    public boolean isStream() {
        return this.isStream;
    }

    public boolean isDatagram() {
        return !this.isStream();
    }

    public String toString() {
        return "service name=" + this.serviceName + ":" + this.port + " [" + (this.side == NetworkConnectionSideType.SERVER ? "server" : (this.side == NetworkConnectionSideType.CLIENT ? "client" : "unconnected")) + (this.isStream ? ", TCP" : ", UDP") + "]";
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = 37 * result + this.port;
        result = 37 * result + this.side.getValue();
        result = 37 * result + (this.isStream ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof NetworkService)) {
            return false;
        }
        NetworkService other = (NetworkService)obj;
        if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
            return false;
        }
        return this.port == other.port && this.side == other.side && this.isStream == other.isStream;
    }
}

