/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.resource;

import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.InlineByFilter;
import com.sap.jvm.profiling.snapshot.elements.InlineByPredefinedFilter;
import com.sap.jvm.profiling.snapshot.elements.RemoveInliners;
import com.sap.jvm.profiling.snapshot.elements.RemovePredefinedInliners;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;

public final class InlineFilterExtractor {
    public static MethodFilter getInlineFilter(ResourceName name) {
        MethodFilter resultInlineByFilter = null;
        MethodFilter resultInlineByPredefinedFilter = null;
        for (ResourceNameElement element : name.getElements()) {
            MethodFilter filter;
            if (element instanceof InlineByFilter) {
                MethodFilter[] newInlineFilters = ((InlineByFilter)element).getFilters();
                filter = MethodFilter.createWide("<artificial>", newInlineFilters, false);
                resultInlineByFilter = resultInlineByFilter == null ? filter : MethodFilter.createWide("<artificial>", new MethodFilter[]{resultInlineByFilter, filter}, true);
            }
            if (element instanceof RemoveInliners) {
                resultInlineByFilter = null;
            }
            if (element instanceof InlineByPredefinedFilter) {
                MethodFilter[] newFilters = ((InlineByPredefinedFilter)element).getFilters();
                filter = MethodFilter.createWide("<artificial>", newFilters, false);
                resultInlineByPredefinedFilter = resultInlineByPredefinedFilter == null ? filter : MethodFilter.createWide("<artificial>", new MethodFilter[]{resultInlineByPredefinedFilter, filter}, true);
            }
            if (!(element instanceof RemovePredefinedInliners)) continue;
            resultInlineByPredefinedFilter = null;
        }
        if (resultInlineByFilter == null) {
            return resultInlineByPredefinedFilter;
        }
        if (resultInlineByPredefinedFilter == null) {
            return resultInlineByFilter;
        }
        return MethodFilter.createWide("<artificial>", new MethodFilter[]{resultInlineByFilter, resultInlineByPredefinedFilter}, true);
    }

    public static MethodFilter getPredefinedInlineFilter(ResourceName name) {
        MethodFilter result = null;
        for (ResourceNameElement element : name.getElements()) {
            if (element instanceof InlineByPredefinedFilter) {
                MethodFilter[] newFilters = ((InlineByPredefinedFilter)element).getFilters();
                MethodFilter filter = MethodFilter.createWide("<artificial>", newFilters, false);
                result = result == null ? filter : MethodFilter.createWide("<artificial>", new MethodFilter[]{result, filter}, true);
            }
            if (!(element instanceof RemovePredefinedInliners)) continue;
            result = null;
        }
        return result;
    }
}

