/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.resource;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public final class NetworkLatencyId {
    private final long id;
    private final long timestamp;

    public NetworkLatencyId(long id, long timestamp) {
        this.id = id;
        this.timestamp = timestamp;
    }

    public NetworkLatencyId(ResourceReader reader) throws IOException {
        this.id = reader.readInt64();
        this.timestamp = reader.readInt64();
    }

    public long getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return (int)(this.id >> 32 ^ this.id ^ (this.timestamp >> 32 ^ this.timestamp));
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkLatencyId) {
            NetworkLatencyId other = (NetworkLatencyId)obj;
            return this.id == other.id && this.timestamp == other.timestamp;
        }
        return false;
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.id);
        writer.writeInt64(this.timestamp);
    }
}

