/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.resource;

import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.resource.InvocationDist;
import java.io.IOException;

public class SimpleInvocationDist
implements InvocationDist {
    public static final SimpleInvocationDist EMPTY = new SimpleInvocationDist(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    public static final SimpleInvocationDist INTERPRETED = new SimpleInvocationDist(1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    public static final SimpleInvocationDist INTERPRETED_NATIVE = new SimpleInvocationDist(0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    public static final SimpleInvocationDist INLINED = new SimpleInvocationDist(0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    public static final SimpleInvocationDist INLINED_NATIVE = new SimpleInvocationDist(0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    public static final SimpleInvocationDist COMPILED = new SimpleInvocationDist(0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L);
    public static final SimpleInvocationDist COMPILED_NATIVE = new SimpleInvocationDist(0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L);
    public static final SimpleInvocationDist INLINED_TIER_1 = new SimpleInvocationDist(0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L);
    public static final SimpleInvocationDist INLINED_NATIVE_TIER_1 = new SimpleInvocationDist(0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L);
    public static final SimpleInvocationDist COMPILED_TIER_1 = new SimpleInvocationDist(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L);
    public static final SimpleInvocationDist COMPILED_NATIVE_TIER_1 = new SimpleInvocationDist(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L);
    public static final SimpleInvocationDist OTHER = new SimpleInvocationDist(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L);
    private static final int VERSION = 1;
    private final long interpreterInvocations;
    private final long nativeInterpreterInvocations;
    private final long inlinedInvocations;
    private final long nativeInlinedInvocations;
    private final long compiledInvocations;
    private final long nativeCompiledInvocations;
    private final long inlinedTier1Invocations;
    private final long nativeInlinedTier1Invocations;
    private final long compiledTier1Invocations;
    private final long nativeCompiledTier1Invocations;
    private final long otherInvocations;

    public SimpleInvocationDist(InvocationDist toCopy) {
        this(toCopy.getInterpreterInvocations(), toCopy.getNativeInterpreterInvocations(), toCopy.getInlinedInvocations(), toCopy.getNativeInlinedInvocations(), toCopy.getCompiledInvocations(), toCopy.getNativeCompiledInvocations(), toCopy.getInlinedTier1Invocations(), toCopy.getNativeInlinedTier1Invocations(), toCopy.getCompiledTier1Invocations(), toCopy.getNativeCompiledTier1Invocations(), toCopy.getOtherInvocations());
    }

    public SimpleInvocationDist(long interpreterInvocations, long nativeInterpreterInvocations, long inlinedInvocations, long nativeInlinedInvocations, long compiledInvocations, long nativeCompiledInvocations, long inlinedTier1Invocations, long nativeInlinedTier1Invocations, long compiledTier1Invocations, long nativeCompiledTier1Invocations, long otherInvocations) {
        this.interpreterInvocations = interpreterInvocations;
        this.nativeInterpreterInvocations = nativeInterpreterInvocations;
        this.inlinedInvocations = inlinedInvocations;
        this.nativeInlinedInvocations = nativeInlinedInvocations;
        this.compiledInvocations = compiledInvocations;
        this.nativeCompiledInvocations = nativeCompiledInvocations;
        this.inlinedTier1Invocations = inlinedTier1Invocations;
        this.nativeInlinedTier1Invocations = nativeInlinedTier1Invocations;
        this.compiledTier1Invocations = compiledTier1Invocations;
        this.nativeCompiledTier1Invocations = nativeCompiledTier1Invocations;
        this.otherInvocations = otherInvocations;
    }

    public SimpleInvocationDist(ResourceReader reader) throws IOException {
        reader.readVersion(1, 1);
        this.interpreterInvocations = reader.readInt64();
        this.nativeInterpreterInvocations = reader.readInt64();
        this.inlinedInvocations = reader.readInt64();
        this.nativeInlinedInvocations = reader.readInt64();
        this.compiledInvocations = reader.readInt64();
        this.nativeCompiledInvocations = reader.readInt64();
        this.inlinedTier1Invocations = reader.readInt64();
        this.nativeInlinedTier1Invocations = reader.readInt64();
        this.compiledTier1Invocations = reader.readInt64();
        this.nativeCompiledTier1Invocations = reader.readInt64();
        this.otherInvocations = reader.readInt64();
    }

    @Override
    public long getInterpreterInvocations() {
        return this.interpreterInvocations;
    }

    @Override
    public long getNativeInterpreterInvocations() {
        return this.nativeInterpreterInvocations;
    }

    @Override
    public long getInlinedInvocations() {
        return this.inlinedInvocations;
    }

    @Override
    public long getNativeInlinedInvocations() {
        return this.nativeInlinedInvocations;
    }

    @Override
    public long getCompiledInvocations() {
        return this.compiledInvocations;
    }

    @Override
    public long getNativeCompiledInvocations() {
        return this.nativeCompiledInvocations;
    }

    @Override
    public long getInlinedTier1Invocations() {
        return this.inlinedTier1Invocations;
    }

    @Override
    public long getNativeInlinedTier1Invocations() {
        return this.nativeInlinedTier1Invocations;
    }

    @Override
    public long getCompiledTier1Invocations() {
        return this.compiledTier1Invocations;
    }

    @Override
    public long getNativeCompiledTier1Invocations() {
        return this.nativeCompiledTier1Invocations;
    }

    @Override
    public long getOtherInvocations() {
        return this.otherInvocations;
    }

    @Override
    public long getTotalInvocations() {
        return this.interpreterInvocations + this.nativeInterpreterInvocations + this.inlinedInvocations + this.nativeInlinedInvocations + this.compiledInvocations + this.nativeCompiledInvocations + this.inlinedTier1Invocations + this.nativeInlinedTier1Invocations + this.compiledTier1Invocations + this.nativeCompiledTier1Invocations + this.otherInvocations;
    }

    @Override
    public SimpleInvocationDist getSum(InvocationDist toAdd) {
        return new SimpleInvocationDist(this.interpreterInvocations + toAdd.getInterpreterInvocations(), this.nativeInterpreterInvocations + toAdd.getNativeInterpreterInvocations(), this.inlinedInvocations + toAdd.getInlinedInvocations(), this.nativeInlinedInvocations + toAdd.getNativeInlinedInvocations(), this.compiledInvocations + toAdd.getCompiledInvocations(), this.nativeCompiledInvocations + toAdd.getNativeCompiledInvocations(), this.inlinedTier1Invocations + toAdd.getInlinedTier1Invocations(), this.nativeInlinedTier1Invocations + toAdd.getNativeInlinedTier1Invocations(), this.compiledTier1Invocations + toAdd.getCompiledTier1Invocations(), this.nativeCompiledTier1Invocations + toAdd.getNativeCompiledTier1Invocations(), this.otherInvocations + toAdd.getOtherInvocations());
    }

    public int compareTo(InvocationDist other) {
        if (this.getInterpreterInvocations() < other.getInterpreterInvocations()) {
            return -1;
        }
        if (this.getInterpreterInvocations() > other.getInterpreterInvocations()) {
            return 1;
        }
        if (this.getNativeInterpreterInvocations() < other.getNativeInterpreterInvocations()) {
            return -1;
        }
        if (this.getNativeInterpreterInvocations() > other.getNativeInterpreterInvocations()) {
            return 1;
        }
        if (this.getCompiledInvocations() < other.getCompiledInvocations()) {
            return -1;
        }
        if (this.getCompiledInvocations() > other.getCompiledInvocations()) {
            return 1;
        }
        if (this.getCompiledTier1Invocations() < other.getCompiledTier1Invocations()) {
            return -1;
        }
        if (this.getCompiledTier1Invocations() > other.getCompiledTier1Invocations()) {
            return 1;
        }
        if (this.getNativeCompiledInvocations() < other.getNativeCompiledInvocations()) {
            return -1;
        }
        if (this.getNativeCompiledInvocations() > other.getNativeCompiledInvocations()) {
            return 1;
        }
        if (this.getNativeCompiledTier1Invocations() < other.getNativeCompiledTier1Invocations()) {
            return -1;
        }
        if (this.getNativeCompiledTier1Invocations() > other.getNativeCompiledTier1Invocations()) {
            return 1;
        }
        if (this.getOtherInvocations() < other.getOtherInvocations()) {
            return -1;
        }
        if (this.getOtherInvocations() > other.getOtherInvocations()) {
            return 1;
        }
        if (this.getInlinedInvocations() < other.getInlinedInvocations()) {
            return -1;
        }
        if (this.getInlinedInvocations() > other.getInlinedInvocations()) {
            return 1;
        }
        if (this.getInlinedTier1Invocations() < other.getInlinedTier1Invocations()) {
            return -1;
        }
        if (this.getInlinedTier1Invocations() > other.getInlinedTier1Invocations()) {
            return 1;
        }
        if (this.getNativeInlinedInvocations() < other.getNativeInlinedInvocations()) {
            return -1;
        }
        if (this.getNativeInlinedInvocations() > other.getNativeInlinedInvocations()) {
            return 1;
        }
        if (this.getNativeInlinedTier1Invocations() < other.getNativeInlinedTier1Invocations()) {
            return -1;
        }
        if (this.getNativeInlinedTier1Invocations() > other.getNativeInlinedTier1Invocations()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(1);
        writer.writeInt64(this.interpreterInvocations);
        writer.writeInt64(this.nativeInterpreterInvocations);
        writer.writeInt64(this.inlinedInvocations);
        writer.writeInt64(this.nativeInlinedInvocations);
        writer.writeInt64(this.compiledInvocations);
        writer.writeInt64(this.nativeCompiledInvocations);
        writer.writeInt64(this.inlinedTier1Invocations);
        writer.writeInt64(this.nativeInlinedTier1Invocations);
        writer.writeInt64(this.compiledTier1Invocations);
        writer.writeInt64(this.nativeCompiledTier1Invocations);
        writer.writeInt64(this.otherInvocations);
    }

    public static SimpleInvocationDist getDist(MethodParameterEntryEvent entry) {
        if (entry.isCompiled()) {
            return COMPILED;
        }
        if (entry.isInterpreted()) {
            return INTERPRETED;
        }
        if (entry.isCompiledTier1()) {
            return COMPILED_TIER_1;
        }
        if (entry.isCompiledNative()) {
            return COMPILED_NATIVE;
        }
        if (entry.isCompiledNativeTier1()) {
            return COMPILED_NATIVE_TIER_1;
        }
        if (entry.isInterpretedNative()) {
            return INTERPRETED_NATIVE;
        }
        if (entry.isOther()) {
            return OTHER;
        }
        if (entry.isInlined()) {
            return INLINED;
        }
        if (entry.isInlinedTier1()) {
            return INLINED_TIER_1;
        }
        if (entry.isInlinedNative()) {
            return INLINED_NATIVE;
        }
        assert (entry.isInlinedNativeTier1());
        return INLINED_NATIVE_TIER_1;
    }
}

