/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.resource;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.Comparator;

public final class SynchronizationEventId
implements Comparable<SynchronizationEventId> {
    private final long id;
    private final long index;
    private static final Comparator<SynchronizationEventId> comparator = new Comparator<SynchronizationEventId>(){

        @Override
        public int compare(SynchronizationEventId o1, SynchronizationEventId o2) {
            return o1.compareTo(o2);
        }
    };

    public SynchronizationEventId(long id, long index) {
        this.id = id;
        this.index = index;
    }

    public SynchronizationEventId(ResourceReader reader) throws IOException {
        this.id = reader.readInt64();
        this.index = reader.readInt64();
    }

    public long getId() {
        return this.id;
    }

    public long getIndex() {
        return this.index;
    }

    public int hashCode() {
        return (int)(this.id >> 32 ^ this.id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SynchronizationEventId) {
            SynchronizationEventId other = (SynchronizationEventId)obj;
            return this.id == other.id;
        }
        return false;
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.id);
        writer.writeInt64(this.index);
    }

    @Override
    public int compareTo(SynchronizationEventId o) {
        return this.id < o.id ? -1 : (this.id > o.id ? 1 : 0);
    }

    public static Comparator<SynchronizationEventId> getComparator() {
        return comparator;
    }
}

