/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.resource;

import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class ThreadIdAndName {
    private final long id;
    private final UTF8String name;

    public ThreadIdAndName(long id, UTF8String name) {
        this.id = id;
        this.name = name;
    }

    public ThreadIdAndName(ResourceReader reader) throws IOException {
        this.id = reader.readInt64();
        this.name = reader.readUTF();
    }

    public long getId() {
        return this.id;
    }

    public UTF8String getUTFName() {
        return this.name;
    }

    public String getName() {
        return this.name.toString();
    }

    public int hashCode() {
        return (int)(this.id >> 32 ^ this.id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ThreadIdAndName) {
            ThreadIdAndName other = (ThreadIdAndName)obj;
            return this.id == other.id;
        }
        return false;
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.id);
        writer.writeUTF(this.name);
    }
}

