/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.rootfinder;

import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.framecombiner.CombinedEntity;
import com.sap.jvm.profiling.snapshot.framecombiner.CombinedEntityMatcher;
import com.sap.jvm.profiling.snapshot.rootfinder.SimpleCalledRootFinderAdapter;
import com.sap.jvm.profiling.util.IntArrayList;

public final class CalledCombinedFramePathsSelfRootFinder
extends SimpleCalledRootFinderAdapter {
    private final CombinedEntityMatcher[][] paths;

    public CalledCombinedFramePathsSelfRootFinder(CombinedEntity[][] paths) {
        this.paths = new CombinedEntityMatcher[paths.length][];
        for (int i = 0; i < paths.length; ++i) {
            this.paths[i] = new CombinedEntityMatcher[paths[i].length];
            for (int j = 0; j < paths[i].length; ++j) {
                this.paths[i][j] = paths[i][j].createMatcher();
            }
        }
    }

    @Override
    protected void addRoots(StackFrames stack, int bottom, int top, IntArrayList rootList) {
        for (int i = 0; i < this.paths.length; ++i) {
            CombinedEntityMatcher[] path = this.paths[i];
            int start = path[0].getBottomMostBottom(stack, false, bottom, top);
            if (start == -1) continue;
            boolean foundPath = true;
            for (int j = 0; j < path.length - 1; ++j) {
                int end = path[j].getTopForBottom(stack, start, top);
                assert (end <= top);
                if (end == top) {
                    foundPath = false;
                    break;
                }
                if (path[j + 1].getBottomMostBottom(stack, false, end, top) != end) {
                    foundPath = false;
                    break;
                }
                start = end;
            }
            if (!foundPath || path[path.length - 1].getTopForBottom(stack, start, top) != top) continue;
            rootList.push(start);
        }
    }
}

