/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.rootfinder;

import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.framecombiner.CombinedEntity;
import com.sap.jvm.profiling.snapshot.framecombiner.CombinedEntityMatcher;
import com.sap.jvm.profiling.snapshot.rootfinder.CalledRootFinder;
import com.sap.jvm.profiling.util.IntArrayList;

public class CalledEntityBottomTotalRootFinder
implements CalledRootFinder {
    private final CombinedEntityMatcher[] entities;

    public CalledEntityBottomTotalRootFinder(CombinedEntity[] entities) {
        this.entities = new CombinedEntityMatcher[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            this.entities[i] = entities[i].createMatcher();
        }
    }

    @Override
    public void getCalledRoots(StackFrames stack, IntArrayList in, IntArrayList out) {
        int bottom = in.getMinValue();
        int top = stack.getNrOfFrames();
        for (int i = 0; i < this.entities.length; ++i) {
            int start = this.entities[i].getBottomMostBottom(stack, true, bottom, top);
            while (start >= 0) {
                out.push(start);
                int startTop = this.entities[i].getTopForBottom(stack, start, top);
                start = this.entities[i].getBottomMostBottom(stack, true, startTop, top);
            }
        }
    }
}

