/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.rootfinder;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.rootfinder.CalledRootFinder;
import com.sap.jvm.profiling.util.IntArrayList;

public final class CalledMethodFilterRootFinder
implements CalledRootFinder {
    private final MethodFilter filter;
    private final MethodFilter inlineFilter;

    public CalledMethodFilterRootFinder(MethodFilter filter, MethodFilter inlineFilter) {
        this.filter = filter;
        this.inlineFilter = inlineFilter;
    }

    @Override
    public void getCalledRoots(StackFrames stack, IntArrayList in, IntArrayList out) {
        int top = stack.getNrOfFrames();
        int bottom = in.getMinValue();
        if (this.inlineFilter != null) {
            int i;
            boolean inlinedAway = true;
            for (i = bottom; i < top; ++i) {
                if (this.inlineFilter.matches(stack.getMethod(i))) continue;
                inlinedAway = false;
                break;
            }
            if (inlinedAway) {
                for (i = bottom; i < top; ++i) {
                    out.push(i);
                }
                return;
            }
        }
        for (int i = bottom; i < top; ++i) {
            MethodObject method = stack.getMethod(i);
            if (!this.filter.matches(method)) continue;
            out.push(i);
        }
    }
}

