/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.rootfinder;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ThreadInfo;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.parameters.MethodParameters;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.snapshot.rootfinder.CalledRootFinder;
import com.sap.jvm.profiling.snapshot.rootfinder.ThreadAwareRootFinder;
import com.sap.jvm.profiling.util.IntArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class CalledParameterValueRootFinder
implements CalledRootFinder,
ThreadAwareRootFinder {
    private final String specName;
    private final HashSet<Parameter> values;
    private ThreadInfo threadInfo;
    private StackFrames frames;

    public CalledParameterValueRootFinder(String specName, Parameter[] values) {
        this.specName = specName;
        this.values = new HashSet<Parameter>(Arrays.asList(values));
    }

    @Override
    public void getCalledRoots(StackFrames stack, IntArrayList in, IntArrayList out) {
        int rootOffset = in.getMinValue();
        MethodParameterEntryEvent[] events = this.threadInfo.getEntryEvents();
        for (int i = this.threadInfo.getEntryEventTop(); i >= 0; --i) {
            MethodParameterEntryEvent event = events[i];
            MethodParameters parameters = event.getParameters();
            boolean specIsMatch = false;
            for (int j = parameters.getNrOfParameters() - 1; j >= 0; --j) {
                if (!parameters.getSpec(j).getName().equals(this.specName) || !this.values.contains(parameters.getParameter(j))) continue;
                specIsMatch = true;
                break;
            }
            if (!specIsMatch) continue;
            this.frames.fillIn(event.getStackTraceIndex());
            assert (this.frames.getNrOfFrames() <= stack.getNrOfFrames());
            if (this.frames.getNrOfFrames() - 1 < rootOffset) continue;
            out.push(this.frames.getNrOfFrames() - 1);
        }
    }

    @Override
    public void setThreadInfo(ThreadInfo info) {
        this.threadInfo = info;
    }

    @Override
    public void setSession(ProfilingSession session) {
        this.frames = session.getStackTraceManager().getStackFramesObject(true);
    }
}

