/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.rootfinder;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.rootfinder.CallingRootFinder;
import com.sap.jvm.profiling.util.IntArrayList;

public class CallingMethodFilterRootFinder
implements CallingRootFinder {
    private final MethodFilter filter;
    private final MethodFilter inlineFilter;

    public CallingMethodFilterRootFinder(MethodFilter filter, MethodFilter inlineFilter) {
        this.filter = filter;
        this.inlineFilter = inlineFilter;
    }

    @Override
    public void getCallingRoots(StackFrames stack, IntArrayList selfIn, IntArrayList nonSelfIn, IntArrayList selfOut, IntArrayList nonSelfOut) {
        if (!selfIn.isEmpty()) {
            this.addRoots(stack, selfIn, selfOut);
        }
        if (!nonSelfIn.isEmpty()) {
            this.addRoots(stack, nonSelfIn, nonSelfOut);
        }
    }

    private void addRoots(StackFrames stack, IntArrayList in, IntArrayList out) {
        int top = in.getMaxValue();
        if (this.inlineFilter != null) {
            int i;
            boolean inlinedAway = true;
            for (i = 0; i <= top; ++i) {
                if (this.inlineFilter.matches(stack.getMethod(i))) continue;
                inlinedAway = false;
                break;
            }
            if (inlinedAway) {
                for (i = 0; i <= top; ++i) {
                    out.push(i);
                }
                return;
            }
        }
        for (int i = 0; i <= top; ++i) {
            MethodObject method = stack.getMethod(i);
            if (!this.filter.matches(method)) continue;
            out.push(i);
        }
    }
}

