/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.rootfinder;

import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.rootfinder.CallingRootFinder;
import com.sap.jvm.profiling.snapshot.util.MethodPath;
import com.sap.jvm.profiling.util.IntArrayList;

public final class CallingMethodPathsRootFinder
implements CallingRootFinder {
    private final MethodPath[] paths;

    public CallingMethodPathsRootFinder(MethodPath[] paths) {
        this.paths = paths;
    }

    @Override
    public void getCallingRoots(StackFrames stack, IntArrayList selfIn, IntArrayList nonSelfIn, IntArrayList selfOut, IntArrayList nonSelfOut) {
        int rootOffset;
        int selfRootOffset = -1;
        if (selfIn.isEmpty()) {
            rootOffset = nonSelfIn.getMaxValue();
        } else {
            selfRootOffset = selfIn.getMaxValue();
            rootOffset = nonSelfIn.isEmpty() ? selfRootOffset : Math.max(selfRootOffset, nonSelfIn.getMaxValue());
        }
        for (MethodPath path : this.paths) {
            if (!path.matchesReverse(stack, rootOffset)) continue;
            if (rootOffset == selfRootOffset) {
                selfOut.push(rootOffset - path.length() + 1);
                continue;
            }
            nonSelfOut.push(rootOffset - path.length() + 1);
        }
    }
}

