/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.sync;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.EOFException;
import java.io.IOException;
import java.util.Comparator;

public final class ReentrantLockObject
implements Comparable<ReentrantLockObject> {
    private final long objectId;
    private static final Comparator<ReentrantLockObject> comparator = new Comparator<ReentrantLockObject>(){

        @Override
        public int compare(ReentrantLockObject o1, ReentrantLockObject o2) {
            return o1.compareTo(o2);
        }
    };

    public ReentrantLockObject(long objectId) {
        this.objectId = objectId;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public String toString() {
        return "reentrant lock with id " + this.objectId;
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.objectId);
    }

    public int hashCode() {
        return (int)(this.objectId ^ this.objectId >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReentrantLockObject) {
            return this.objectId == ((ReentrantLockObject)obj).objectId;
        }
        return false;
    }

    public static ReentrantLockObject read(ResourceReader reader) throws EOFException {
        long objectId = reader.readInt64();
        return new ReentrantLockObject(objectId);
    }

    @Override
    public int compareTo(ReentrantLockObject o) {
        return this.objectId < o.objectId ? -1 : (this.objectId == o.objectId ? 0 : 1);
    }

    public static Comparator<ReentrantLockObject> getComparator() {
        return comparator;
    }
}

