/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.tbs;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.tbs.SimpleTimeDist;
import com.sap.jvm.profiling.snapshot.tbs.TimeAndDist;
import java.io.IOException;

public class SimpleTimeAndDist
implements TimeAndDist {
    public static final SimpleTimeAndDist EMPTY = new SimpleTimeAndDist(0L, 0L, 0L, SimpleTimeDist.EMPTY, SimpleTimeDist.EMPTY);
    private static final int VERSION = 0;
    private final long time;
    private final long cpuTime;
    private final long sleepingTime;
    private final SimpleTimeDist timeDistribution;
    private final SimpleTimeDist cpuTimeDistribution;

    public SimpleTimeAndDist(TimeAndDist toCopy) {
        this(toCopy.getTime(), toCopy.getCpuTime(), toCopy.getSleepingTime(), new SimpleTimeDist(toCopy.getTimeDistribution()), new SimpleTimeDist(toCopy.getCpuTimeDistribution()));
    }

    public SimpleTimeAndDist(long time, long cpuTime, long sleepingTime, SimpleTimeDist timeDistribution, SimpleTimeDist cpuTimeDistribution) {
        this.time = time;
        this.cpuTime = cpuTime;
        this.sleepingTime = sleepingTime;
        this.timeDistribution = timeDistribution;
        this.cpuTimeDistribution = cpuTimeDistribution;
    }

    public SimpleTimeAndDist(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.time = reader.readInt64();
        this.cpuTime = reader.readInt64();
        this.sleepingTime = reader.readInt64();
        this.timeDistribution = new SimpleTimeDist(reader);
        this.cpuTimeDistribution = new SimpleTimeDist(reader);
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public long getCpuTime() {
        return this.cpuTime;
    }

    @Override
    public long getSleepingTime() {
        return this.sleepingTime;
    }

    @Override
    public SimpleTimeDist getTimeDistribution() {
        return this.timeDistribution;
    }

    @Override
    public SimpleTimeDist getCpuTimeDistribution() {
        return this.cpuTimeDistribution;
    }

    @Override
    public SimpleTimeAndDist getSum(TimeAndDist toAdd) {
        return new SimpleTimeAndDist(this.time + toAdd.getTime(), this.cpuTime + toAdd.getCpuTime(), this.sleepingTime + toAdd.getSleepingTime(), this.timeDistribution.getSum(toAdd.getTimeDistribution()), this.cpuTimeDistribution.getSum(toAdd.getCpuTimeDistribution()));
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt64(this.time);
        writer.writeInt64(this.cpuTime);
        writer.writeInt64(this.sleepingTime);
        this.timeDistribution.write(writer);
        this.cpuTimeDistribution.write(writer);
    }

    @Override
    public long getMaxTime() {
        return Math.max(this.time, this.cpuTime) + this.sleepingTime;
    }
}

