/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.tbs;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.tbs.TimeDist;
import java.io.IOException;

public class SimpleTimeDist
implements TimeDist {
    public static final SimpleTimeDist EMPTY = new SimpleTimeDist(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    private static final int VERSION = 1;
    private final long interpreterTime;
    private final long nativeInterpreterTime;
    private final long inlinedTime;
    private final long nativeInlinedTime;
    private final long compiledTime;
    private final long nativeCompiledTime;
    private final long inlinedTier1Time;
    private final long nativeInlinedTier1Time;
    private final long compiledTier1Time;
    private final long nativeCompiledTier1Time;
    private final long otherTime;

    public SimpleTimeDist(TimeDist toCopy) {
        this(toCopy.getInterpreterTime(), toCopy.getNativeInterpreterTime(), toCopy.getInlinedTime(), toCopy.getNativeInlinedTime(), toCopy.getCompiledTime(), toCopy.getNativeCompiledTime(), toCopy.getInlinedTier1Time(), toCopy.getNativeInlinedTier1Time(), toCopy.getCompiledTier1Time(), toCopy.getNativeCompiledTier1Time(), toCopy.getOtherTime());
    }

    public SimpleTimeDist(long interpreterTime, long nativeInterpreterTime, long inlinedTime, long nativeInlinedTime, long compiledTime, long nativeCompiledTime, long inlinedTier1Time, long nativeInlinedTier1Time, long compiledTier1Time, long nativeCompiledTier1Time, long otherTime) {
        this.interpreterTime = interpreterTime;
        this.nativeInterpreterTime = nativeInterpreterTime;
        this.inlinedTime = inlinedTime;
        this.nativeInlinedTime = nativeInlinedTime;
        this.compiledTime = compiledTime;
        this.nativeCompiledTime = nativeCompiledTime;
        this.inlinedTier1Time = inlinedTier1Time;
        this.nativeInlinedTier1Time = nativeInlinedTier1Time;
        this.compiledTier1Time = compiledTier1Time;
        this.nativeCompiledTier1Time = nativeCompiledTier1Time;
        this.otherTime = otherTime;
    }

    public SimpleTimeDist(ResourceReader reader) throws IOException {
        reader.readVersion(1, 1);
        this.interpreterTime = reader.readInt64();
        this.nativeInterpreterTime = reader.readInt64();
        this.inlinedTime = reader.readInt64();
        this.nativeInlinedTime = reader.readInt64();
        this.compiledTime = reader.readInt64();
        this.nativeCompiledTime = reader.readInt64();
        this.inlinedTier1Time = reader.readInt64();
        this.nativeInlinedTier1Time = reader.readInt64();
        this.compiledTier1Time = reader.readInt64();
        this.nativeCompiledTier1Time = reader.readInt64();
        this.otherTime = reader.readInt64();
    }

    @Override
    public long getInterpreterTime() {
        return this.interpreterTime;
    }

    @Override
    public long getNativeInterpreterTime() {
        return this.nativeInterpreterTime;
    }

    @Override
    public long getInlinedTime() {
        return this.inlinedTime;
    }

    @Override
    public long getNativeInlinedTime() {
        return this.nativeInlinedTime;
    }

    @Override
    public long getCompiledTime() {
        return this.compiledTime;
    }

    @Override
    public long getNativeCompiledTime() {
        return this.nativeCompiledTime;
    }

    @Override
    public long getInlinedTier1Time() {
        return this.inlinedTier1Time;
    }

    @Override
    public long getNativeInlinedTier1Time() {
        return this.nativeInlinedTier1Time;
    }

    @Override
    public long getCompiledTier1Time() {
        return this.compiledTier1Time;
    }

    @Override
    public long getNativeCompiledTier1Time() {
        return this.nativeCompiledTier1Time;
    }

    @Override
    public long getOtherTime() {
        return this.otherTime;
    }

    @Override
    public long getTotalTime() {
        return this.interpreterTime + this.nativeInterpreterTime + this.inlinedTime + this.nativeInlinedTime + this.compiledTime + this.nativeCompiledTime + this.inlinedTier1Time + this.nativeInlinedTier1Time + this.compiledTier1Time + this.nativeCompiledTier1Time + this.otherTime;
    }

    @Override
    public SimpleTimeDist getSum(TimeDist toAdd) {
        return new SimpleTimeDist(this.interpreterTime + toAdd.getInterpreterTime(), this.nativeInterpreterTime + toAdd.getNativeInterpreterTime(), this.inlinedTime + toAdd.getInlinedTime(), this.nativeInlinedTime + toAdd.getNativeInlinedTime(), this.compiledTime + toAdd.getCompiledTime(), this.nativeCompiledTime + toAdd.getNativeCompiledTime(), this.inlinedTier1Time + toAdd.getInlinedTier1Time(), this.nativeInlinedTier1Time + toAdd.getNativeInlinedTier1Time(), this.compiledTier1Time + toAdd.getCompiledTier1Time(), this.nativeCompiledTier1Time + toAdd.getNativeCompiledTier1Time(), this.otherTime + toAdd.getOtherTime());
    }

    public int compareTo(TimeDist other) {
        if (this.getInterpreterTime() < other.getInterpreterTime()) {
            return -1;
        }
        if (this.getInterpreterTime() > other.getInterpreterTime()) {
            return 1;
        }
        if (this.getNativeInterpreterTime() < other.getNativeInterpreterTime()) {
            return -1;
        }
        if (this.getNativeInterpreterTime() > other.getNativeInterpreterTime()) {
            return 1;
        }
        if (this.getCompiledTime() < other.getCompiledTime()) {
            return -1;
        }
        if (this.getCompiledTime() > other.getCompiledTime()) {
            return 1;
        }
        if (this.getCompiledTier1Time() < other.getCompiledTier1Time()) {
            return -1;
        }
        if (this.getCompiledTier1Time() > other.getCompiledTier1Time()) {
            return 1;
        }
        if (this.getNativeCompiledTime() < other.getNativeCompiledTime()) {
            return -1;
        }
        if (this.getNativeCompiledTime() > other.getNativeCompiledTime()) {
            return 1;
        }
        if (this.getNativeCompiledTier1Time() < other.getNativeCompiledTier1Time()) {
            return -1;
        }
        if (this.getNativeCompiledTier1Time() > other.getNativeCompiledTier1Time()) {
            return 1;
        }
        if (this.getOtherTime() < other.getOtherTime()) {
            return -1;
        }
        if (this.getOtherTime() > other.getOtherTime()) {
            return 1;
        }
        if (this.getInlinedTime() < other.getInlinedTime()) {
            return -1;
        }
        if (this.getInlinedTime() > other.getInlinedTime()) {
            return 1;
        }
        if (this.getInlinedTier1Time() < other.getInlinedTier1Time()) {
            return -1;
        }
        if (this.getInlinedTier1Time() > other.getInlinedTier1Time()) {
            return 1;
        }
        if (this.getNativeInlinedTime() < other.getNativeInlinedTime()) {
            return -1;
        }
        if (this.getNativeInlinedTime() > other.getNativeInlinedTime()) {
            return 1;
        }
        if (this.getNativeInlinedTier1Time() < other.getNativeInlinedTier1Time()) {
            return -1;
        }
        if (this.getNativeInlinedTier1Time() > other.getNativeInlinedTier1Time()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(1);
        writer.writeInt64(this.interpreterTime);
        writer.writeInt64(this.nativeInterpreterTime);
        writer.writeInt64(this.inlinedTime);
        writer.writeInt64(this.nativeInlinedTime);
        writer.writeInt64(this.compiledTime);
        writer.writeInt64(this.nativeCompiledTime);
        writer.writeInt64(this.inlinedTier1Time);
        writer.writeInt64(this.nativeInlinedTier1Time);
        writer.writeInt64(this.compiledTier1Time);
        writer.writeInt64(this.nativeCompiledTier1Time);
        writer.writeInt64(this.otherTime);
    }
}

