/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.tbs.elements;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.SnapshotDefiningElement;
import com.sap.jvm.profiling.snapshot.tbs.elements.RunningType;
import java.io.IOException;
import java.util.Arrays;

public class FilterByRunningType
implements SnapshotDefiningElement {
    private static final String TAG = "filter by running type for the performance hotspot trace";
    private static final int VERSION = 0;
    private final RunningType[] types;

    public FilterByRunningType() {
        this(new RunningType[0]);
    }

    public FilterByRunningType(RunningType[] types) {
        this.types = types;
    }

    public FilterByRunningType(ResourceReader reader) throws IOException {
        reader.readVersion(0);
        this.types = new RunningType[reader.readInt32()];
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i] = RunningType.read(reader);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterByRunningType) {
            FilterByRunningType other = (FilterByRunningType)obj;
            return Arrays.equals((Object[])this.types, (Object[])other.types);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode() ^ Arrays.hashCode((Object[])this.types);
    }

    public String toString() {
        return "filter by running type " + Arrays.toString((Object[])this.types) + " for the performance hotspot trace";
    }

    public RunningType[] getRunningTypes() {
        return (RunningType[])this.types.clone();
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.types.length);
        for (RunningType type : this.types) {
            type.write(writer);
        }
    }

    public String getTag() {
        return TAG;
    }
}

