/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.tbs.elements;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public enum RunningType {
    COMPILED,
    INTERPRETED,
    NATIVE,
    COMPILED_NON_NATIVE,
    INLINED_NON_NATIVE,
    INTERPRETED_NON_NATIVE,
    COMPILED_NATIVE,
    INLINED_NATIVE,
    INTERPRETED_NATIVE,
    COMPILED_NON_NATIVE_TIER1,
    INLINED_NON_NATIVE_TIER1,
    COMPILED_NATIVE_TIER1,
    INLINED_NATIVE_TIER1,
    OTHER;

    private static final int VERSION = 1;

    public static RunningType read(ResourceReader reader) throws IOException {
        reader.readVersion(1);
        byte type = reader.readInt8();
        switch (type) {
            case 0: {
                return COMPILED;
            }
            case 1: {
                return INTERPRETED;
            }
            case 2: {
                return NATIVE;
            }
            case 3: {
                return COMPILED_NON_NATIVE;
            }
            case 4: {
                return INLINED_NON_NATIVE;
            }
            case 5: {
                return INTERPRETED_NON_NATIVE;
            }
            case 6: {
                return COMPILED_NATIVE;
            }
            case 7: {
                return INLINED_NATIVE;
            }
            case 8: {
                return INTERPRETED_NATIVE;
            }
            case 9: {
                return COMPILED_NON_NATIVE_TIER1;
            }
            case 10: {
                return INLINED_NON_NATIVE_TIER1;
            }
            case 11: {
                return COMPILED_NATIVE_TIER1;
            }
            case 12: {
                return INLINED_NATIVE_TIER1;
            }
            case 13: {
                return OTHER;
            }
        }
        throw new IOException("Invalid running type " + type);
    }

    public void write(ResourceWriter writer) throws IOException {
        int tag = -1;
        switch (this) {
            case COMPILED: {
                tag = 0;
                break;
            }
            case INTERPRETED: {
                tag = 1;
                break;
            }
            case NATIVE: {
                tag = 2;
                break;
            }
            case COMPILED_NON_NATIVE: {
                tag = 3;
                break;
            }
            case INLINED_NON_NATIVE: {
                tag = 4;
                break;
            }
            case INTERPRETED_NON_NATIVE: {
                tag = 5;
                break;
            }
            case COMPILED_NATIVE: {
                tag = 6;
                break;
            }
            case INLINED_NATIVE: {
                tag = 7;
                break;
            }
            case INTERPRETED_NATIVE: {
                tag = 8;
                break;
            }
            case COMPILED_NON_NATIVE_TIER1: {
                tag = 9;
                break;
            }
            case INLINED_NON_NATIVE_TIER1: {
                tag = 10;
                break;
            }
            case COMPILED_NATIVE_TIER1: {
                tag = 11;
                break;
            }
            case INLINED_NATIVE_TIER1: {
                tag = 12;
                break;
            }
            case OTHER: {
                tag = 13;
            }
        }
        writer.writeVersion(1);
        writer.writeInt8(tag);
    }
}

