/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.thread;

import com.sap.jvm.profiling.i18n.I18n;

public enum ThreadDumpTreeItemType {
    UNKNOWN(0, I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Unknown")),
    THREAD_ROOT_DESCRIPTION(1, I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Entry for the description of a thread")),
    THREAD_SUB_DESCRIPTION(2, I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Entry for the description of a thread")),
    THREAD_STACKFRAME(3, I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Entry for a stack frame element of a thread")),
    THREAD_WAITING(4, I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Entry for an object the thread is waiting for")),
    THREAD_BLOCKED(5, I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Entry for an object the thread is trying to get the lock")),
    THREAD_LOCKED(6, I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Entry for an object the thread has locked")),
    THREAD_SOCKETINFO(7, I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Entry for additional socket information"));

    private final String description;
    private final int value;

    private ThreadDumpTreeItemType(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public static ThreadDumpTreeItemType getThreadDumpTreeItemType(int value) {
        ThreadDumpTreeItemType[] itemTypes = ThreadDumpTreeItemType.values();
        if (value >= 0 && value < itemTypes.length && itemTypes[value].value == value) {
            return itemTypes[value];
        }
        for (int i = 0; i < itemTypes.length; ++i) {
            if (itemTypes[i].value != value) continue;
            return itemTypes[i];
        }
        throw new IllegalArgumentException("Unknown thread entry type " + value);
    }
}

