/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.thread.compare.hints;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import java.util.List;

public interface ThreadDumpHintHotspot
extends ThreadDumpHint {
    public int getNumberHits();

    public int getTotalNumberHits();

    public MethodObject getHotspotMethod();

    public List<StackPrefixInfo> getStackPrefixInfo();

    public static class StackPrefixInfo {
        private List<ThreadDumpItem> items;
        private int stackPrefix;
        private StackFrames stackFrames;

        public StackPrefixInfo(List<ThreadDumpItem> items, int stackPrefix, StackFrames stackFrames) {
            this.items = items;
            this.stackPrefix = stackPrefix;
            this.stackFrames = stackFrames;
        }

        public void merge(StackPrefixInfo stackPrefixRhs) {
            this.items.addAll(stackPrefixRhs.getItems());
            this.stackPrefix = Math.min(this.stackPrefix, stackPrefixRhs.getStackPrefix());
        }

        public List<ThreadDumpItem> getItems() {
            return this.items;
        }

        public int getNumHits() {
            return this.items.size();
        }

        public int getStackPrefix() {
            return this.stackPrefix;
        }

        public StackFrames getStackFrames() {
            return this.stackFrames;
        }
    }
}

